import { BunkerKeyBusinessesNode } from 'client/bundles/types';
import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function (req: Request, res: Response, next: NextFunction) {
    const pageName = 'keyBusinesses';

    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, pageName);
    const keyBusinessesData = bunker.pages['key-businesses'];

    if (!keyBusinessesData) {
        next();

        return;
    }

    const { isWiki } = keyBusinessesData;
    let { note, structure } = keyBusinessesData;

    if (isWiki) {
        note = note ? await getFormattedText(note) : '';

        const preparedSection = async function (structurItem: BunkerKeyBusinessesNode) {
            return await Promise.all(structurItem.subnodes.map(async (subnode: BunkerKeyBusinessesNode) => {
                const content = keyBusinessesData.isWiki && subnode.content ?
                    await getFormattedText(subnode.content) :
                    subnode.content;

                return {
                    ...subnode,
                    content
                };
            }));
        };

        structure = await Promise.all(structure.map(async structurItem => {
            const subnodes = await preparedSection(structurItem);

            return {
                ...structurItem,
                subnodes
            };
        }));
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        keyBusinesses: {
            ...keyBusinessesData,
            structure,
            note
        }
    });
}
