import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';

export default function keyDocuments(req: Request, res: Response, next: NextFunction) {
    const pageName = 'keyDocuments';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, 'governance');

    if (!bunker.pages.governance || !bunker.pages.governance.documents) {
        next();

        return;
    }

    const { title, documents } = bunker.pages.governance;

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sectionTitle: title,
        documents
    });
}
