import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';

export default function sustainability(req: Request, res: Response, next: NextFunction) {
    const pageName = 'latestPresentation';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, pageName);
    const latestPresentationPageData = bunker.pages['latest-presentation'];

    if (!latestPresentationPageData) {
        next();

        return;
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        latestPresentation: latestPresentationPageData
    });
}
