import { NextFunction, Request, Response } from 'express';

import { mainDocsName } from 'client/bundles/types';

export default function mainDocument(req: Request, res: Response, next: NextFunction) {
    const { bunker } = req;

    const pathDoc = req.path.replace('/', '');

    const docUrl = bunker.pages && bunker.pages[pathDoc as mainDocsName];

    if (!docUrl) {
        next();

        return;
    }

    res.redirect(docUrl.link);
}
