import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function management(req: Request, res: Response, next: NextFunction) {
    const pageName = 'management';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, 'governance');
    const managementData = bunker.pages.governance?.management;

    if (!bunker.pages.governance || !managementData) {
        next();

        return;
    }

    let managementList = managementData.list;

    if (managementData.isWiki) {
        managementList = await Promise.all(managementList.map(async item => {
            return {
                ...item,
                bio: await getFormattedText(item.bio)
            };
        }));
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sectionTitle: bunker.pages.governance.title,
        management: {
            ...managementData,
            list: managementList
        }
    });
}
