import { Request, Response } from 'express';

const REDIRECTS: Record<string, string> = {
    '1064890': '/financial-releases?year=2018&report=q1',
    '1023170': '/financial-releases?year=2017&report=q1',
    '967757': '/financial-releases?year=2016&report=q1',
    '908998': '/financial-releases?year=2015&report=q1',
    '842189': '/financial-releases?year=2014&report=q1',
    '759253': '/financial-releases?year=2013&report=q1',
    '1034881': '/financial-releases?year=2017&report=q2',
    '981596': '/financial-releases?year=2016&report=q2',
    '924678': '/financial-releases?year=2015&report=q2',
    '862524': '/financial-releases?year=2014&report=q2',
    '780214': '/financial-releases?year=2013&report=q2',
    '1045050': '/financial-releases?year=2017&report=q3',
    '995776': '/financial-releases?year=2016&report=q3',
    '938526': '/financial-releases?year=2015&report=q3',
    '877696': '/financial-releases?year=2014&report=q3',
    '799642': '/financial-releases?year=2013&report=q3',
    '717047': '/financial-releases?year=2012&report=q3',
    '1057604': '/financial-releases?year=2017&report=q4',
    '1012130': '/financial-releases?year=2016&report=q4',
    '954912': '/financial-releases?year=2015&report=q4',
    '896809': '/financial-releases?year=2014&report=q4',
    '826948': '/financial-releases?year=2013&report=q4',
    '741167': '/financial-releases?year=2012&report=q4'
};

export default function oldFinancial(req: Request, res: Response) {
    const releaseID = req.query.ReleaseID;

    if (!releaseID || typeof releaseID !== 'string') {
        res.redirect('/financial-releases');

        return;
    }

    const releasePath = REDIRECTS[releaseID];

    if (!releasePath) {
        res.redirect('/financial-releases');

        return;
    }

    res.redirect(releasePath);
}
