import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function ourPrinciples(req: Request, res: Response, next: NextFunction) {
    const { bunker, query: { section } } = req;

    if (!bunker.pages.principles) {
        next();

        return;
    }

    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    const { title, defaultNode, isWiki, ...principlesData } = bunker.pages.principles;

    const sectionIds = Object.keys(principlesData);

    const isRequestedValidSection = section && typeof section === 'string' && sectionIds.includes(section);

    const defaultNodeId = sectionIds.includes(defaultNode as unknown as string) ? defaultNode : sectionIds[0];
    const sectionId = isRequestedValidSection ? section : defaultNodeId;

    let principlesList = principlesData[sectionId as string].list;

    if (isWiki) {
        principlesList = await Promise.all(principlesList.map(async item => {
            return await getFormattedText(item);
        }));
    }

    res.renderBundle('desktop', 'ourPrinciples', {
        ...getCommonPageData(req, res),
        principles: {
            title,
            section: {
                ...principlesData[sectionId as string],
                list: principlesList
            },
            sectionId
        }
    });
}
