import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function keyDocuments(req: Request, res: Response, next: NextFunction) {
    const pageName = 'overview';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, 'governance');

    if (!bunker.pages.governance || !bunker.pages.governance.overview) {
        next();

        return;
    }

    const { title, overview } = bunker.pages.governance;
    let { text } = overview;

    if (overview.isWiki) {
        text = await getFormattedText(text);
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sectionTitle: title,
        overview: {
            ...overview,
            text
        }
    });
}
