import { NextFunction, Request, Response } from 'express';

import blogsProvider from 'server/providers/blogs-provider';
import { getCommonPageData } from 'server/utils/page-utils';

const FIRST_YEAR = 2005;

export default (req: Request, res: Response, next: NextFunction) => {
    const { year, id } = req.query;
    const commonPageData = getCommonPageData(req, res, 'news');
    const pageName = 'pressReleases';

    // Получаем несколько последних постов, чтобы узнать самый последний год, за который есть новости
    blogsProvider.getPressReleases(req, { postName: 'posts' })
        .then(pressReleases => {
            if (pressReleases.length === 0) {
                res.renderBundle('desktop', pageName, {
                    ...commonPageData,
                    pressReleases: {}
                });

                return;
            }

            const yearsWithLastPressReleases = pressReleases.map(pressRelease => new Date(pressRelease.date).getFullYear());
            const [lastYear] = yearsWithLastPressReleases;

            // Запросили главную или невалидный год или год, за который нет ни одной новости.
            if (!year || isNaN(Number(year)) || Number(year) < FIRST_YEAR || Number(year) > lastYear) {
                res.redirect(`/press-releases?year=${lastYear}`);

                return;
            }

            const promise = id ? blogsProvider.getPressRelease : blogsProvider.getPressReleases;
            const options = id ?
                { year: String(year), postName: 'post', postId: String(id) } :
                { year: String(year), postName: 'postsArchive' };

            const years: string[] = [];

            for (let i = lastYear; i >= FIRST_YEAR; i = i - 1) {
                years.push(String(i));
            }

            promise(req, options)
                .then(result => {
                    const items = Array.isArray(result) ? result.filter(item => !item.ignoreInIndex) : undefined;
                    const item = Array.isArray(result) ? undefined : result;

                    res.renderBundle('desktop', pageName, {
                        ...commonPageData,
                        pressReleases: {
                            items,
                            item,
                            currentYear: year,
                            years
                        }
                    });
                })
                .catch(() => next());
        })
        .catch(() => next());
};
