import { Request, Response } from 'express';
import blogsProvider from 'server/providers/blogs-provider';

const _ = require('lodash');

export default function subscribe(req: Request, res: Response): void {
    if (!req.query.email || typeof req.query.email !== 'string') {
        res.send({
            error: {
                statusCode: 400,
                body: 'Subscribe error: email should not be empty'
            }
        });

        return;
    }

    blogsProvider.subscribe(req, req.query.email)
        .then(data => {
            let result;

            if (!data) {
                result = JSON.stringify({ result: { status: 'ok' } });
            }

            res.send(result);
        })
        .catch(error => {
            console.log('Subscribe error:', error.statusCode, error.message);

            let errorBody = _.get(error.response, 'body');

            if (typeof errorBody === 'string') {
                try {
                    errorBody = JSON.parse(errorBody);
                } catch (e) {
                    throw new Error('Body blog error type is invalid');
                }
            }

            res.send(JSON.stringify({
                error: {
                    statusCode: error.statusCode || 500,
                    body: errorBody
                }
            }));
        });
}
