import { NextFunction, Request, Response } from 'express';
import { getSustainabilityType } from 'server/utils/bunker-utils';

export default function sustainabilityDocument(req: Request, res: Response, next: NextFunction) {
    const { bunker } = req;

    const pathDoc = req.path.replace('/sustainability/', '');

    const sustainabilityType = getSustainabilityType(pathDoc);
    const sustainabilityPageUrl = sustainabilityType &&
        bunker.pages.sustainability &&
        bunker.pages.sustainability[sustainabilityType];

    if (!sustainabilityPageUrl || !sustainabilityPageUrl.link) {
        next();

        return;
    }

    res.redirect(sustainabilityPageUrl.link);
}
