import { NextFunction, Request, Response } from 'express';
import { getSustainabilityType } from 'server/utils/bunker-utils';
import { getCommonPageData } from 'server/utils/page-utils';

export default function sustainabilityWebcast(req: Request, res: Response, next: NextFunction) {
    const { bunker } = req;

    const pathPage = req.path.replace('/sustainability/', '');
    const sustainabilityType = getSustainabilityType(pathPage);

    const sustainabilityWebcastPageData = sustainabilityType &&
        bunker.pages.sustainability &&
        bunker.pages.sustainability[sustainabilityType];

    if (!sustainabilityWebcastPageData || !sustainabilityWebcastPageData.link) {
        next();

        return;
    }

    const pageName = 'webcast';

    const commonPageData = getCommonPageData(req, res, pageName);

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        webcast: sustainabilityWebcastPageData
    });
}
