import { NextFunction, Request, Response } from 'express';
import { getCommonPageData } from 'server/utils/page-utils';

export default function sustainability(req: Request, res: Response, next: NextFunction) {
    const pageName = 'sustainability';
    const { bunker } = req;
    const commonPageData = getCommonPageData(req, res, pageName);
    const sustainabilityPageData = bunker.pages.sustainability;

    if (!sustainabilityPageData) {
        next();

        return;
    }

    res.renderBundle('desktop', pageName, {
        ...commonPageData,
        sustainability: sustainabilityPageData
    });
}
