import cfg from '@yandex-int/yandex-cfg';
import got from 'got';

type ApiGotOptions = Omit<got.GotJSONOptions, 'json'> & {
    query?: object;
};

export default function (
    url: got.GotUrl,
    rawOptions?: ApiGotOptions
): Promise<string> {
    const options = rawOptions || {};

    options.method = options.method || 'GET';

    const testingEnv = ['testing', 'local', 'development'].indexOf(cfg.environment) !== -1;

    if (testingEnv) {
        options.rejectUnauthorized = false;
    }

    return got(url, options)
        .then(data => {
            return data.body;
        })
        .catch(error => {
            console.log(`error request to ${url}\n ${error.message}`);
            throw error;
        });
}

export { ApiGotOptions };
