import { NextFunction, Request, Response } from 'express';

import renderBundle from './render-bundle';

export default (req: Request, res: Response, next: NextFunction) => {
    res.renderBundle = (bundleName, pageName, data) => {
        const lang = 'en';
        const location = req.url;
        const { html, redirectUrl } = renderBundle({ bundleName, data, lang, location, pageName });

        if (redirectUrl) {
            res.redirect(redirectUrl);

            return;
        }

        res.send(html);
    };

    next();
};
