import { Application } from 'express';
import redirect from 'express-redirect';

const REDIRECTS: Record<string, string> = {
    '/news-releases/news-release-details/yandex-announces-first-quarter-2020-financial-results': '/financial-releases?year=2020&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2019-financial-results': '/financial-releases?year=2019&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2018-financial-results': '/financial-releases?year=2018&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2017-financial-results': '/financial-releases?year=2017&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2016-financial-results': '/financial-releases?year=2016&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2015-financial-results': '/financial-releases?year=2015&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2014-financial-results': '/financial-releases?year=2014&report=q1',
    '/news-releases/news-release-details/yandex-announces-first-quarter-2013-financial-results': '/financial-releases?year=2013&report=q1',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2020-financial-results': '/financial-releases?year=2020&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2019-financial-results': '/financial-releases?year=2019&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2018-financial-results': '/financial-releases?year=2018&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2017-financial-results': '/financial-releases?year=2017&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2016-financial-results': '/financial-releases?year=2016&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2015-financial-results': '/financial-releases?year=2015&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2014-financial-results': '/financial-releases?year=2014&report=q2',
    '/news-releases/news-release-details/yandex-announces-second-quarter-2013-financial-results': '/financial-releases?year=2013&report=q2',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2020-financial-results': '/financial-releases?year=2020&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2019-financial-results': '/financial-releases?year=2019&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2018-financial-results': '/financial-releases?year=2018&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2017-financial-results': '/financial-releases?year=2017&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2016-financial-results': '/financial-releases?year=2016&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2015-financial-results': '/financial-releases?year=2015&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2014-financial-results': '/financial-releases?year=2014&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2013-financial-results': '/financial-releases?year=2013&report=q3',
    '/news-releases/news-release-details/yandex-announces-third-quarter-2012-financial-results': '/financial-releases?year=2012&report=q3',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2019-financial': '/financial-releases?year=2019&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2018-financial': '/financial-releases?year=2018&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2017-financial': '/financial-releases?year=2017&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2016-financial': '/financial-releases?year=2016&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2015-financial': '/financial-releases?year=2015&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2014-financial': '/financial-releases?year=2014&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2013-financial': '/financial-releases?year=2013&report=q4',
    '/news-releases/news-release-details/yandex-announces-fourth-quarter-and-full-year-2012-financial': '/financial-releases?year=2012&report=q4',

    '/rss/news-releases.xml': '/press-releases/news.rss',

    '/node/*': '/financial-releases',
    '/releases.cfm': '/financial-releases',
    '(/index.php)?/news-releases/news-release-details/*': '/financial-releases',
    '/index.php': '/',

    '/sec.cfm': '/sec-filings',
    '/contactus.cfm': '/contact-us',
    '/sec-filings/sec-filing/*': '/sec-filings',
    '/documents.cfm': '/corporate-governance',
    '/events.cfm': '/events-and-presentations',
    '/annual-general-meeting.cfm': '/shareholder-meetings',
    '/annual-meeting': '/shareholder-meetings',
    '/directors.cfm': '/corporate-governance/board-of-directors',
    '/index.php/:section/:page': '/:section/:page',
    '/index.php/:page': '/:page'
};

export default function (app: Application): void {
    redirect(app);

    Object.keys(REDIRECTS).forEach(from =>
        app.redirect(from, REDIRECTS[from], 301)
    );
}
