import { Request, Response } from 'express';

import cfg from '@yandex-int/yandex-cfg';
import { getMenuFromBunker, getPrefooter } from 'server/utils/bunker-utils';

// eslint-disable-next-line import/prefer-default-export
// tslint:disable-next-line:no-any
export function getCommonPageData(req: Request, res: Response, pageName?: string): any {
    const resHeaders = res.getHeaders();
    const {
        bunker,
        ip,
        nonce,
        uatraits
    } = req;

    const metrika = {
        metrikaId: cfg.metrikaCounterId,
        metrikaOptions: cfg.metrikaOptions
    };

    return {
        // Создаются в страничных контроллерах
        analysts: {},
        directors: {},
        documents: {},
        governance: {},
        meetings: {},
        events: {},
        financials: {},
        faq: {},
        structure: {},

        ip,
        nonce,
        resHeaders,
        uatraits,
        faviconLang: 'en',
        isTestingEnv: ['testing', 'local', 'development'].includes(cfg.environment),
        menu: getMenuFromBunker(bunker, pageName),
        metrika,
        prefooter: getPrefooter(bunker),
        baseUrl: this.getBaseUrl(req)
    };
}

export function getBaseUrl(req: Request): string {
    return `${req.protocol}://${req.hostname}${req.path}`;
}

export function getFinancialPageUrl(req: Request, params: {year: string; name: string}): string {
    const path = 'financial-releases';
    let baseUrl = this.getBaseUrl(req);

    if (!baseUrl.includes(path)) {
        baseUrl = baseUrl + path;
    }

    return `${baseUrl}?year=${params.year}&report=${params.name}`;
}
