// @ts-ignore
import { parseWikiMd } from '@yandex-int/remark-woofmd';
import { create } from '@yandex-int/woof';
// @ts-ignore
import { formatMdAst } from '@yandex-int/woofmd-to-bemjson';
import LRU from 'lru-cache';
import md5 from 'md5';

const cache = new LRU<string, Promise<string | undefined>>({
    maxAge: 1000 * 60 * 60 * 24 * 30, // 30 day
    max: 200 // max count fields in the cache
});

const FORMATTER_CONFIG = {
    lang: 'en',
    platform: 'desktop',
    instance: 'business',
    'wiki_url': ''
};

// @ts-ignore
const formatter = create(FORMATTER_CONFIG);
const configFormatter = formatter.getConfig();

export default function getFormattedText(text: string): Promise<string> {
    const cacheName = md5(text);

    if (!cache.has(cacheName)) {
        cache.set(cacheName, formatText(text));
    }

    // @ts-ignore
    return cache
        .get(cacheName)
        .then((formattedText: string) => {
            if (formattedText) {
                return formattedText;
            }

            cache.del(cacheName);

            return text;
        })
        .catch((error: Error) => {
            console.error(error);
            cache.del(cacheName);

            return text;
        });

}

async function formatText(text: string): Promise<string> {
    const ast = parseWikiMd(text, configFormatter);
    const bemjson = await formatMdAst(ast, configFormatter);

    // Хак: Переопределяю wiki-аттрибуты в результирующем bemjson,
    // чтобы в html не выливать много лишнего кода
    bemjson['wiki-attrs'] = FORMATTER_CONFIG;

    const formattedRes = await formatter.bemjsonToHtml(bemjson);

    // Хак: replace нужен, чтобы у ссылок не было title
    return formattedRes.replace(/title="External link \(opens in new window\)"/gmi, '');
}
