/* eslint complexity: 0 */

import { join } from 'path';

import cfg from '@yandex-int/yandex-cfg';
import BrotliWebpackPlugin from 'brotli-webpack-plugin';
import CompressionWebpackPlugin from 'compression-webpack-plugin';
import ForkTsCheckerPlugin from 'fork-ts-checker-webpack-plugin';
import MiniCssExtractPlugin from 'mini-css-extract-plugin';
import { TsconfigPathsPlugin } from 'tsconfig-paths-webpack-plugin';
import webpack from 'webpack';

import { STATS_OPTIONS } from './config';
import { CLIENT_DIR, DIST_DIR, ROOT_DIR } from './dir';
import { ENV, IS_DEV, IS_PRODUCTION } from './env';

import * as loaders from './loaders';

const vendorsManifest = require(join(DIST_DIR, 'webpack-configs', 'vendors-manifest.json'));

function getConfig(lang: string, index: number): webpack.Configuration {
    // Т.к. все сборки отличаются только переводами, то проверять типы можно только один раз
    const shouldCheckTypes = index === 0;

    return {
        name: `client_${lang}`,
        target: 'web',
        devtool: IS_PRODUCTION ? false : 'source-map',
        entry: {
            desktop: [
                IS_DEV && 'css-hot-loader/hotModuleReplacement',
                IS_DEV && `webpack-hot-middleware/client?path=/__webpack_hmr_${index}`,
                join(CLIENT_DIR, 'bundles', 'desktop')
            ].filter(Boolean) as string[]
        },
        output: {
            filename: `[name].bundle.${lang}.js`,
            library: 'Client',
            libraryTarget: 'var',
            path: join(DIST_DIR, 'client'),
            publicPath: '/static/'
        },
        module: {
            rules: [
                loaders.legoI18N,
                loaders.css.client,
                loaders.typescript.client,
                loaders.file.client,
                loaders.url,
                loaders.svg.client
            ]
        },
        resolve: {
            extensions: ['.js', '.ts', '.tsx'],
            plugins: [
                new TsconfigPathsPlugin({ configFile: join(ROOT_DIR, 'tsconfig.json') })
            ]
        },
        plugins: [
            new webpack.DllReferencePlugin({
                context: ROOT_DIR,
                manifest: vendorsManifest
            }),
            new MiniCssExtractPlugin({
                filename: '[name].bundle.css'
            }),
            !IS_DEV && new BrotliWebpackPlugin({ minRatio: 1 }),
            !IS_DEV && new CompressionWebpackPlugin({ minRatio: 1 }),
            new webpack.DefinePlugin({
                'process.env.NODE_ENV': JSON.stringify(ENV),
                'process.env.BEM_LANG': JSON.stringify(lang)
            }),
            shouldCheckTypes && new ForkTsCheckerPlugin({
                watch: IS_DEV ? [CLIENT_DIR] : undefined,
                tsconfig: join(ROOT_DIR, 'tsconfig.json')
            }),
            IS_DEV && new webpack.HotModuleReplacementPlugin()
        ].filter(Boolean) as webpack.Plugin[],
        stats: STATS_OPTIONS
    };
}

export default cfg.langs.map(getConfig);
