import cfg from '@yandex-int/yandex-cfg';

const filenameRegexp = /^(?!.*\.inline).*\.(jpe?g|png|gif|eot|woff2?|ttf)$/;

export default {
    client: {
        loader: 'file-loader',
        test: filenameRegexp,
        query: {
            name: '[hash].[ext]',
            outputPath: './_',
            publicPath: cfg.static.baseUrl + cfg.static.frozenPath
        }
    },

    ssr: {
        loader: 'file-loader',
        test: filenameRegexp,
        query: {
            name: '[hash].[ext]',
            outputPath: './client/_',
            publicPath: cfg.static.baseUrl + cfg.static.frozenPath
        }
    }
};
