import { join } from 'path';

import BrotliWebpackPlugin from 'brotli-webpack-plugin';
import CompressionWebpackPlugin from 'compression-webpack-plugin';
import MiniCssExtractPlugin from 'mini-css-extract-plugin';
import webpack from 'webpack';

import { STATS_OPTIONS, VENDORS } from './config';
import { ROOT_DIR_FROM_WEBPACK } from './dir';
import { IS_DEV } from './env';

const DIST_DIR = join(ROOT_DIR_FROM_WEBPACK, 'dist');

const config: webpack.Configuration = {
    target: 'web',
    devtool: 'source-map',
    entry: {
        vendors: VENDORS
    },
    output: {
        library: '[name]_[hash]',
        filename: '[name]_[hash].js',
        path: join(DIST_DIR, 'client', '_')
    },
    plugins: [
        new webpack.DllPlugin({
            name: '[name]_[hash]',
            path: join(DIST_DIR, 'webpack-configs', 'vendors-manifest.json')
        }),
        new MiniCssExtractPlugin({ filename: '[name]_[hash].css' }),
        !IS_DEV && new BrotliWebpackPlugin({ minRatio: 1 }),
        !IS_DEV && new CompressionWebpackPlugin({ minRatio: 1 })
    ].filter(Boolean) as webpack.Plugin[],
    stats: STATS_OPTIONS
};

export default config;
