'use strict';
const config = require('yandex-cfg');
const express = require('express');
const expressBundleResponse = require('express-bundle-response');

const app = express();

app.use('/static', express.static(config.static.dir, {
    fallthrough: false,
    maxAge: 365 * 24 * 60 * 60 * 1000
}));

app.use(expressBundleResponse(config.view));

require('./router')(app);

module.exports = app;
