/**
 * COPY AND PASTE FROM
 * https://github.yandex-team.ru/Afisha/afisha-frontend/blob/master/static/.enb/enb/techs/priv-to-bemjson.js
 *
 * priv-to-bemjson
 * =================
 *
 * Собирает *bemjson*-файл с помощью *priv* и *css*
 *
 * **Опции**
 *
 * * *String* **privFile** — Исходный priv-файл. По умолчанию — `?.{lang}.priv.js`.
 * * *String* **target** — Результирующий bemjson-файл. По умолчанию — `?.{lang}.bemjson.js`.
 * * *String* **lang** — Язык на котором собирается bemjson.
 * * *String* **css** — Исходный css-файл. По умолчанию - `?.css`
 * * *String* **ie8** — Исходный css-файл для ie8. По умолчанию - `?.ie8.css`
 * * *String* **ie9** — Исходный css-файл для ie9. По умолчанию - `?.ie9.css`
 *
 * **Пример**
 *
 * ```javascript
 * [ require("./enb/techs/priv-to-bemjson"), {
 *      blockName: 'b-page',
 *      lang: "{lang}",
 *      privFile: "?.{lang}.priv.js",
 *      target: "?.{lang}.bemjson.js",
 *      css: "?.css",
 *      ie9: "?.ie9.css"
 *  }]
 * ```
 */

var enb = require('enb');
var vfs = require('enb/lib/fs/async-fs');

module.exports = require('enb/lib/build-flow').create()
    .name('priv-to-bemjson')
    .target('target', '?.{lang}.bemjson.js')
    .defineRequiredOption('lang')
    .defineRequiredOption('blockName')
    .defineRequiredOption('data')
    .useSourceFilename('privFile', '?.{lang}.priv.js')
    .useSourceText('css', '?.css')
    .useSourceText('ie9', '?.ie9.css')
    .builder(function (privFile, css, ie8, ie9) {
        var node = this.node;
        var lang = this._lang;
        var blockName = this._blockName;
        var blocks = require(privFile);
        var data = Object.assign({
            language: lang,
            type: node._targetName
        }, this._data);

        var bemjson = blocks.exec(blockName, data);

        return 'module.exports = ' + JSON.stringify(bemjson);
    })
    .createTech();
