module.exports = function (bh) {
    bh.match('analyst-coverage', function (ctx) {
        var data = {
            head: { firm: 'Firm', analyst: 'Analyst' },
            items: [
                { firm: 'Alfa Bank', analyst: 'Aleksandra Melnikova' },
                { firm: 'Bank of America Merrill Lynch', analyst: 'Cesar Tiron' },
                { firm: 'BCS', analyst: 'Mitch Mitchell' },
                { firm: 'Citi', analyst: 'Brady Martin' },
                { firm: 'Credit Suisse', analyst: 'Olga Bystrova' },
                { firm: 'Deutsche Bank', analyst: 'Lloyd Walmsley' },
                { firm: 'Gazprombank', analyst: 'Sergey Vasin' },
                { firm: 'Goldman Sachs', analyst: 'Vyacheslav Degtyarev' },
                { firm: 'HSBC', analyst: 'Dmytro Konovalov' },
                { firm: 'Jefferies', analyst: 'David Reynolds' },
                { firm: 'JP Morgan', analyst: 'Alexei Gogolev' },
                { firm: 'Morgan Stanley', analyst: 'Miriam Adisa' },
                { firm: 'Otkritie Capital', analyst: 'Alexander Vengranovich' },
                { firm: 'Raiffeisenbank', analyst: 'Sergey Libin' },
                { firm: 'Renaissance Capital', analyst: 'David Ferguson' },
                { firm: 'Sberbank CIB', analyst: 'Svetlana Sukhanova' },
                { firm: 'Sberbank CIB', analyst: 'Maria Sukhanova' },
                { firm: 'UBS', analyst: 'Ulyana Lenvalskaya' },
                { firm: 'Uralsib', analyst: 'Konstantin Chernyshev' },
                { firm: 'Uralsib', analyst: 'Konstantin Belov' },
                { firm: 'VTB Capital', analyst: 'Vladimir Bespalov' }
            ]
        };

        ctx
            .content([
                {
                    block: 'page-title',
                    content: 'Analyst Coverage'
                },
                {
                    block: 'analyst-list',
                    data: data
                },
                {
                    block: 'text',
                    tag: 'p',
                    mods: { note: true },
                    content: [
                        'Yandex is followed by the analyst(s) listed above. Please note that any opinions, estimates',
                        'or forecasts regarding Yandex\'s performance made by these analysts are theirs alone and do ',
                        'not represent opinions, forecasts or predictions ',
                        'of Yandex or its management. Yandex does not by its reference above or distribution imply',
                        'its endorsement of or concurrence with such information, conclusions or recommendations.'
                    ]
                }
            ]);
    });
};
