module.exports = function (bh) {
    bh.match('analyst-list', function (ctx) {
        var data = ctx.param('data');

        ctx
            .content([
                {
                    elem: 'head',
                    content: [
                        {
                            elem: 'left',
                            content: data.head.firm
                        },
                        {
                            elem: 'right',
                            content: data.head.analyst
                        }
                    ]
                },
                getItems(data.items)
            ]);
    });

    function getItems(items) {
        return items.map(function (item) {
            return {
                elem: 'line',
                content: [
                    {
                        elem: 'left',
                        content: item.firm
                    },
                    {
                        elem: 'right',
                        content: item.analyst
                    }
                ]
            };
        });
    }
};
