module.exports = function (blocks) {
    'use strict';
    blocks.declare('b-page', data => [
        {
            block: 'i-global',
            params: {
                lang: 'en',
                tld: 'com',
                'content-region': 'com'
            }
        },
        {
            block: 'b-page',
            title: 'Investor Relations - Yandex',
            head: [
                { elem: 'css', url: `${data.staticHost}/desktop.bundles/index/_index.css`, ie: false },
                { elem: 'css', url: `${data.staticHost}/desktop.bundles/index/_index.ie9.css`, ie: 'IE 9' },
                { elem: 'favicon', url: 'https://yastatic.net/iconostasis/_/KKii9ECKxo3QZnchF7ayZhbzOT8.png' }
            ],
            meta: [
                { elem: 'meta', attrs: { name: 'viewport', content: 'width=device-width,maximum-scale=1,initial-scale=1,user-scalable=0' }}
            ],
            xUaCompatible: 'IE=edge',
            content: [
                {
                    elem: 'wrapper',
                    content: {
                        elem: 'inner',
                        content: [
                            { block: 'logo-print' },
                            { block: 'head' },
                            { block: 'site-menu' },
                            {
                                elem: 'content',
                                content: [
                                    {
                                        block: 'sec-filings',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'ask-question',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'subscription',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'confirmation',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'financial-release',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'sec-filings-flex',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'stock-data',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'events',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'meetings',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'directors',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'analyst-coverage',
                                        mix: {
                                            block: 'content'
                                        }
                                    },
                                    {
                                        block: 'financial-releases',
                                        mix: {
                                            block: 'content'
                                        }
                                    }
                                ]
                            },
                            { block: 'contact' },
                            { block: 'foot' },
                            { block: 'fog' },
                            { block: 'nav' }
                        ]
                    }
                },
                { block: 'i-jquery', mods: { version: 'default' }},
                {
                    elem: 'js',
                    url: 'https://api-maps.yandex.ru/2.1?lang=en_US'
                },
                {
                    elem: 'js',
                    url: `${data.staticHost}/desktop.bundles/index/_index.en.js`
                },
                {
                    block: 'b-statcounter',
                    content: {
                        elem: 'metrika',
                        js: {
                            clickmap: true,
                            trackLinks: true,
                            accurateTrackBounce: true,
                            webvisor: true,
                            trackHash: true
                        },
                        elemMods: {
                            type: 'js'
                        },
                        counter: '927493'
                    }
                }
            ]
        }
    ]);
};
