module.exports = function (bh) {
    bh.match('city-contact', function (ctx) {
        var data = ctx.param('city');

        ctx
            .js(true)
            .attrs({ id: data.id })
            .mods({ visibility: data.default ? 'visible' : 'hidden', map: 'hidden' })
            .content([
                data.photo && {
                    elem: 'image',
                    content: {
                        block: 'image',
                        mods: { visibility: 'visible' },
                        url: data.photo.src,
                        alt: data.photo.alt
                    }
                },
                {
                    elem: 'map'
                },
                {
                    elem: 'columns',
                    content: data.columns.map(function (column) {
                        return {
                            elem: 'column',
                            content: column.items.map(function (item) {
                                return {
                                    elem: 'item',
                                    content: [
                                        item.head && {
                                            block: 'text',
                                            tag: 'h4',
                                            content: item.head
                                        },
                                        {
                                            content: item.text
                                        },
                                        item.map && {
                                            block: 'map-link',
                                            mapData: item.map
                                        }
                                    ]
                                };
                            })
                        };
                    })
                }
            ]);
    });
};
