BEM.DOM.decl('city-contact', {
    onSetMod: {
        js: function () {
            this.mapLinks = this.findBlocksInside('map-link');
            this.imageCity = this.findBlockInside('image');
            this.mapElem = this.findElem('map');

            var that = this;
            this.mapContent = [];
            this.mapLinks.forEach(function (link, linkIndex) {
                that.mapContent.push(that._getCurrentMap(link.params));

                link.bindTo('click tap', function () {
                    that._toggleMap(link, linkIndex);
                });
            });
        }
    },

    _toggleMap: function (link, linkIndex) {
        var isMapVisible = this.getMod('map') === 'visible';
        var isLinkVisible = link.getMod('map') === 'visible';

        if (!isMapVisible && !isLinkVisible) {
            this._toggleMods(link);
            BEM.DOM.update(this.mapElem, this.mapContent[linkIndex]);
            return;
        }

        if (isMapVisible && !isLinkVisible) {
            this.mapLinks.forEach(function (link) {
                link.setMod('map', 'hidden');
            });

            this.setMod('map', 'visible');
            link.setMod('map', 'visible');

            if (this.imageCity) {
                this.delMod(this.imageCity, 'visibility', 'visible');
            }
            BEM.DOM.update(this.mapElem, this.mapContent[linkIndex]);
            return;
        }

        if (isMapVisible && isLinkVisible) {
            this._toggleMods(link);
            this.mapElem.empty();
        }
    },

    _toggleMods: function (link) {
        this.toggleMod('map', 'hidden', 'visible');
        link.toggleMod('map', 'hidden', 'visible');
        if (this.imageCity) {
            this.imageCity.toggleMod('visibility', 'visible', 'hidden');
        }
    },

    _getCurrentMap: function (mapParams) {
        return BH.apply({
            block: 'map-content',
            js: {
                map: {
                    latitude: mapParams.latitude,
                    longitude: mapParams.longitude,
                    zoom: mapParams.zoom
                }
            },
            mods: { visibility: 'visible' },
            content: { elem: 'map' }
        });
    }
});
