module.exports = function (bh) {
    bh.match('contact', function (ctx) {
        var cities = getCitiesData();

        ctx
            .tag('section')
            .js(true)
            .content({
                elem: 'content',
                content: [
                    {
                        block: 'page-title',
                        content: 'Contact Us'
                    },
                    {
                        elem: 'cols',
                        content: [
                            {
                                elem: 'column',
                                mods: { left: true },
                                content: [
                                    {
                                        elem: 'section',
                                        content: [
                                            {
                                                elem: 'section-header',
                                                content: [
                                                    {
                                                        block: 'text',
                                                        tag: 'h2',
                                                        content: 'Yandex N.V.'
                                                    },
                                                    {
                                                        block: 'text',
                                                        mods: { tip: true },
                                                        content: 'Registered Office in Amsterdam'
                                                    }
                                                ]
                                            },
                                            {
                                                elem: 'text',
                                                content: [
                                                    'Schiphol Boulevard 165, 1118 BG Schiphol, The Netherlands',
                                                    '<br>',
                                                    'tel.: <a href="tel:+310202066970">+31 0 20 206 6970</a>'
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        elem: 'section',
                                        content: [
                                            {
                                                elem: 'section-header',
                                                content: [
                                                    {
                                                        block: 'text',
                                                        tag: 'h2',
                                                        content: 'Yandex LLC'
                                                    },
                                                    {
                                                        block: 'text',
                                                        mods: { tip: true },
                                                        content: 'Headquarters in Russia'
                                                    }
                                                ]
                                            },
                                            {
                                                elem: 'text',
                                                content: [
                                                    {
                                                        elem: 'select',
                                                        content: [
                                                            {
                                                                elem: 'select-txt',
                                                                content: {
                                                                    block: 'button2',
                                                                    mods: {
                                                                        view: 'classic',
                                                                        theme: 'pseudo',
                                                                        size: 'm',
                                                                        disabled: 'yes',
                                                                        tone: 'default'
                                                                    },
                                                                    text: 'Office in'
                                                                }
                                                            },
                                                            {
                                                                block: 'select-adaptive',
                                                                content: {
                                                                    block: 'select2',
                                                                    mods: { native: 'yes', theme: 'pseudo', size: 'm', type: 'radio', text: 'vary', tone: 'default', view: 'classic'},
                                                                    name: 'officies-adaptive',
                                                                    control: {
                                                                        elem: 'control',
                                                                        elemMods: { native: 'yes' }
                                                                    },
                                                                    items: cities.map(function (city) {
                                                                        return { val: city.id, text: city.name };
                                                                    })
                                                                }
                                                            },
                                                            {
                                                                block: 'select-desktop',
                                                                content: {
                                                                    block: 'select2',
                                                                    mods: { theme: 'pseudo', size: 'm', type: 'radio', text: 'vary', tone: 'default', view: 'classic'},
                                                                    name: 'officies',
                                                                    control: true,
                                                                    items: cities.map(function (city) {
                                                                        return { val: city.id, text: city.name };
                                                                    })
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        elem: 'data',
                                                        cities: cities
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                elem: 'column',
                                mods: { right: true },
                                content: [
                                    {
                                        elem: 'section',
                                        content: [
                                            {
                                                block: 'text',
                                                tag: 'h3',
                                                content: 'Questions'
                                            },
                                            {
                                                elem: 'text',
                                                content: 'Questions for the Investor Relations Department can be submitted through the button below'
                                            },
                                            {
                                                elem: 'button',
                                                content: {
                                                    block: 'button2',
                                                    mods: {
                                                        type: 'link',
                                                        theme: 'action',
                                                        size: 'n',
                                                        view: 'default',
                                                        tone: 'default'
                                                    },
                                                    text: 'Ask a question',
                                                    url: '#'
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        elem: 'section',
                                        content: [
                                            {
                                                block: 'text',
                                                tag: 'h3',
                                                content: 'Subscribe to press releases'
                                            },
                                            {
                                                elem: 'text',
                                                content: 'You may automatically receive Yandex financial information by email'
                                            },
                                            {
                                                elem: 'button',
                                                content: {
                                                    block: 'button2',
                                                    mods: {
                                                        type: 'link',
                                                        theme: 'action',
                                                        size: 'n',
                                                        view: 'default',
                                                        tone: 'default'
                                                    },
                                                    text: 'Subscribe',
                                                    url: '#'
                                                }
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            });
    });

    bh.match('contact__data', function (ctx) {
        ctx.content(
            ctx.param('cities').map(function (city) {
                return {
                    block: 'city-contact',
                    city: city
                };
            })
        );
    });

    function getCitiesData() {
        return [
            {
                id: 'moscow',
                name: 'Moscow',
                default: true,
                photo: {
                    src: 'https://avatars.mds.yandex.net/get-adv/28496/2a000001616cc7574206f66da2fb28161019/orig',
                    alt: 'Yandex LLC Office in Moscow'
                },
                columns: [
                    {
                        items: [
                            {
                                head: 'Headquaters',
                                text: [
                                    '16, Leo Tolstoy St., Moscow, Russia 119021<br>',
                                    'tel.&nbsp;',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'tel:+74957397000' },
                                        content: '+7&nbsp;495&nbsp;739-70-00'
                                    },
                                    '<br>',
                                    'fax&nbsp;',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'tel:+74957397070' },
                                        content: '+7&nbsp;495&nbsp;739-70-70'
                                    }
                                ],
                                map: { latitude: '55.733771', longitude: '37.587937' }
                            },
                            {
                                head: 'Avrora Business Centre',
                                text: [
                                    ' 82, Sadovnicheskaya&nbsp;St., building&nbsp;2, Moscow, Russia 115035<br>',
                                    'tel.&nbsp;',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'tel:+74957397000' },
                                        content: '+7&nbsp;495&nbsp;739-70-00'
                                    },
                                    '<br>',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'tel:+74959743581' },
                                        content: '+7 495 974-35-81'
                                    },
                                    '<br>',
                                    'fax&nbsp;',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'tel:+74957397070' },
                                        content: '+7&nbsp;495&nbsp;739-70-70'
                                    }
                                ],
                                map: { latitude: '55.734873172377014', longitude: '37.64259065670743', zoom: '17' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Investor Relations',
                                text: [
                                    {
                                        tag: 'a',
                                        attrs: { href: 'tel:+74959743538' },
                                        content: '+7&nbsp;495&nbsp;974-35-38'
                                    },
                                    '<br>',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'mailto:askIR@yandex-team.ru' },
                                        content: 'askIR@yandex-team.ru'
                                    }
                                ]
                            },
                            {
                                head: 'Advertising clients',
                                text: [
                                    'tel.:&nbsp;<a href="tel:+74957393777">+7 495 739-37-77</a>,',
                                    '<br>fax:&nbsp;<a href="tel:+74957392332">+7&nbsp;495&nbsp;739-23-32</a>',
                                    '<br>',
                                    {
                                        tag: 'a',
                                        attrs: { href: 'mailto:eng-ad@yandex-team.ru' },
                                        content: 'eng-ad@yandex-team.ru'
                                    }
                                ]
                            },
                            {
                                head: 'Public relations',
                                text: {
                                    tag: 'a',
                                    attrs: { href: 'mailto:pr@yandex-team.ru' },
                                    content: 'pr@yandex-team.ru'
                                }
                            }
                        ]
                    }
                ]
            },
            {
                id: 'spb',
                name: 'Saint Petersburg',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: [
                                    'Piskariovski Boulevard, building 2, block 2, Benois',
                                    ' Business Centre, Saint Petersburg 195027, Russia'
                                ],
                                map: { latitude: '59.958584', longitude: '30.405224' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Reception',
                                text: 'tel.: <a href="tel:+78126333600">+7 812 633-36-00</a>,<br>' +
                                'fax: <a href="tel:+78126333699">+7 812 633-36-99</a><br>' +
                                '<a href="tel:88002509639">8&nbsp;800&nbsp;250-96-39</a>' +
                                ' (or <a href="tel:88002509639">8&nbsp;800&nbsp;250-YNDX</a>)<br>' +
                                'Calls to 800 numbers are toll-free from Russia\'s regions'
                            },
                            {
                                head: 'Sales Office',
                                text: '<a href="mailto:spbsales@yandex-team.ru">spbsales@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'ekaterinburg',
                name: 'Ekaterinburg',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '10, Khokhryakova St., Ekaterinburg, Russia 620014',
                                map: { latitude: '56.835554', longitude: '60.590944' }
                            },
                            {
                                head: 'Reception',
                                text: 'tel.: <a href="tel:+73432148400">+7 343 214-84-00</a>'
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Sales Office',
                                text: 'tel.: <a href="tel:+73433850100">+7 343 385-01-00</a>,<br>' +
                                    'fax: <a href="tel:+73433850199">+7&nbsp;343&nbsp;385-01-99</a>' +
                                    '<br><a href="mailto:uralsales@yandex-team.ru">uralsales@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'nsk',
                name: 'Novosibirsk',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '35, Krasnoyarskaya St., Novosibirsk, Russia 630004',
                                map: { latitude: '55.040373', longitude: '82.900451' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Sales Office',
                                text: 'tel.: <a href="tel:+73832304306">+7 383 230-43-06</a>' +
                                    '<br><a href="mailto:sales-nsk@yandex-team.ru">sales-nsk@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'kazan',
                name: 'Kazan',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '6, Spartakovskaya St., Kazan, Russia 420107',
                                map: { latitude: '55.778593', longitude: '49.129411' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Sales Office',
                                text: 'tel.: <a href="tel:+78435247171">+7&nbsp;843&nbsp;524-71-71</a>' +
                                    '<br><a href="mailto:kzn-sales@yandex-team.ru">kzn-sales@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'innopolis',
                name: 'Innopolis',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: 'Technopark, 3rd floor, offices 301 and 303, 7, Universitetskaya St.,' +
                                ' Innopolis, Russia 420500',
                                map: { latitude: '55.751873', longitude: '48.752936' }
                            }
                        ]
                    },
                    {
                        items: [
                            { head: '&nbsp;', text: 'tel.: <a href="tel:+78435247171">+7&nbsp;843&nbsp;524-71-71</a>' }
                        ]
                    }
                ]
            },
            {
                id: 'rostov',
                name: 'Rostov-on-Don',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: 'Dolomanovski Lane 70D, Gvardeyski Business Centre, Rostov-on-Don, Russia 344011',
                                map: { latitude: '47.227139', longitude: '39.695294' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Sales Office',
                                text: 'tel.: <a href="tel:+78632688300">+7 863 2-688-300</a>' +
                                '<br><a href="mailto:rndsales@yandex-team.ru">rndsales@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'nnovgorod',
                name: 'Nizhny Novgorod',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '10/16, Alekseyevskaya St., Lobachevski Plaza, Nizhny' +
                                    ' Novgorod, Russia 603005',
                                map: { latitude: '56.322661', longitude: '44.005598' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Reception',
                                text: 'tel.: <a href="tel:+78312330606">+7&nbsp;831&nbsp;233-06-06</a>' +
                                ' (or&nbsp;<a href="tel:88002342480">8&nbsp;800&nbsp;234-24-80</a>)' +
                                ' Calls to 800 numbers are toll-free from Russia\'s regions'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'simferopol',
                name: 'Simferopol',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '1a, Kazanskaya&nbsp;St., Simferopol 295006',
                                map: { latitude: '44.954491', longitude: '34.091607' }
                            }
                        ]
                    },
                    {
                        items: [
                            { head: 'Reception', text: 'tel.: <a href="tel:+74957397070">+7 495 739-70-70</a>' }
                        ]
                    }
                ]
            },
            {
                id: 'vladivostok',
                name: 'Vladivostok',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '17, Okeanski Boulevard, 10th&nbsp;floor, office&nbsp;1012,' +
                                ' Fresh&nbsp;Plaza Business&nbsp;Centre, Vladivostok, Russia 690091',
                                map: { latitude: '43.119694', longitude: '131.886566' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+78002342480">8 800 234-24-80</a>,' +
                                    '<br><a href="mailto:client-service@yandex-team.ru">client-service@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'krasnodar',
                name: 'Krasnodar',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '15,&nbsp;Komsomolskaya&nbsp;St., Ascona Business Centre, 12th&nbsp;floor,' +
                                ' office&nbsp;224, Krasnodar, Russia 350063',
                                map: { latitude: '45.02087607460901', longitude: '38.96097599999999' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+7800234-24-80">8 800 234-24-80</a>,' +
                                    '<br><a href="mailto:client-service@yandex-team.ru">client-service@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'saratov',
                name: 'Saratov',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '91, Volskaya&nbsp;St., Stolypin Business Centre, 4th&nbsp;floor,' +
                                ' office&nbsp;412, Saratov, Russia 410012',
                                map: { latitude: '51.53430168863141', longitude: '46.02542706745908' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+7800234-24-80">8 800 234-24-80</a>,' +
                                    '<br><a href="mailto:client-service@yandex-team.ru">client-service@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'samara',
                name: 'Samara',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '78, Michurina&nbsp;St., Millenium Business Center, 6th&nbsp;Floor, Office&nbsp;603,' +
                                ' Samara, Russia 443110',
                                map: { latitude: '53.20592157120167', longitude: '50.14396799999995' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+7800234-24-80">8 800 234-24-80</a>,' +
                                    '<br><a href="mailto:client-service@yandex-team.ru">client-service@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'chelyabinsk',
                name: 'Chelyabinsk',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '26А, bld.&nbsp;2, Lenina Boulevard, Bovid Business Center, 6th&nbsp;Floor,' +
                                ' Office&nbsp;608 and&nbsp;611, Chelyabinsk, Russia 454007',
                                map: { latitude: '55.1617567846288', longitude: '61.42944646560658' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+7800234-24-80">8 800 234-24-80</a>,' +
                                    '<br><a href="mailto:client-service@yandex-team.ru">client-service@yandex-team.ru</a>'                            }
                        ]
                    }
                ]
            },
            {
                id: 'minsk',
                name: 'Minsk (Belarus)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '5, Dzerzhinskogo Boulevard, Rubin&nbsp;Plaza Business&nbsp;Centre, Office&nbsp;707, Minsk,' +
                                ' Belarus 220036',
                                map: { latitude: '53.89053', longitude: '27.5258' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Reception',
                                text: 'tel.: <a href="tel:+375173281961">+375 17 328-19-61</a>,<br>' +
                                    'fax: <a href="tel:+375173281514">+375 17 328-15-14</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'almaty',
                name: 'Almaty (Kazakhstan)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '43, Dostyk Boulevard, Almaty, Kazakhstan 050010',
                                map: { latitude: '43.251374', longitude: '76.955436' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+77273132805">+7 727 313-28-05</a><br>' +
                                    '<a href="mailto:infokz@yandex-team.ru">infokz@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'newburyport',
                name: 'Newburyport (USA)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: '38R Merrimac St., Suite&nbsp;201, Yandex&nbsp;Inc., Newburyport, MA 01950 United States',
                                map: { latitude: '42.811993494741884', longitude: '-70.87494413754274', zoom: '15' }
                            }
                        ]
                    },
                    {
                        items: [
                            { head: 'Reception', text: 'tel.: <a href="tel:+16173987870">+1 617 398 7870</a>' }
                        ]
                    }
                ]
            },
            {
                id: 'istanbul',
                name: 'Istanbul (Turkey)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: 'Kolektif House Levent Yandex / Esentepe Mah. Talatpaşa Caddesi No:5,34330' +
                                ' Levent, Şişli-İstanbul, Türkiye',
                                map: { latitude: '41.079770', longitude: '29.008629' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: 'Reception',
                                text: '<a href="mailto:pr@yandex.com.tr">pr@yandex.com.tr</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'lucerne',
                name: 'Lucerne (Switzerland)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: 'Citybay Business Center, Werftestrasse&nbsp;4, CH 6005 Lucerne, Switzerland',
                                map: { latitude: '47.04771996', longitude: '8.31426821' }
                            }
                        ]
                    },
                    {
                        items: [
                            {
                                head: '&nbsp;',
                                text: 'tel.: <a href="tel:+41412480860">+41 41 248-08-60</a>, <br>' +
                                'fax.: <a href="tel:+41412480863">+41 41 248-08-63</a><br>' +
                                '<a href="mailto:saleseurope@yandex-team.ru">saleseurope@yandex-team.ru</a>'
                            }
                        ]
                    }
                ]
            },
            {
                id: 'berlin',
                name: 'Berlin (Germany)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: 'Karl-Liebknecht-Straße, 1, 10178 Berlin, Germany',
                                map: { latitude: '52.519306', longitude: '13.402756' }
                            }
                        ]
                    },
                    {
                        items: [
                            { head: '&nbsp;', text: 'tel.: <a href="tel:+4930233224700">+49 30 233 224 700</a>' }
                        ]
                    }
                ]
            },
            {
                id: 'shanghai',
                name: 'Shanghai (China)',
                columns: [
                    {
                        items: [
                            {
                                head: 'Address',
                                text: 'WeWork, Office 327, 135 Yanping Road, Jing\'an District, Shanghai, China,' +
                                ' 200042',
                                map: { latitude: '31.23106', longitude: '121.4361', zoom: '14' }
                            }
                        ]
                    },
                    {
                        items: [
                            { head: '&nbsp;', text: 'tel.: <a href="tel:+862160793689">+86 21 60793689</a>' }
                        ]
                    }
                ]
            }
        ];
    }
};
