module.exports = function (bh) {
    bh.match('director', function (ctx) {
        var data = ctx.param('item');

        ctx
            .js(true)
            .content([
                {
                    elem: 'name',
                    content: [
                        {
                            elem: 'left',
                            content: data.name
                        },
                        {
                            elem: 'right',
                            content: data.position
                        }
                    ]
                },
                {
                    elem: 'about',
                    content: [
                        {
                            elem: 'close'
                        },
                        {
                            block: 'text',
                            tag: 'h2',
                            content: data.name
                        },
                        {
                            block: 'text',
                            mods: { tip: true },
                            content: data.position
                        },
                        {
                            block: 'text',
                            mods: { size: 'l' },
                            tag: 'p',
                            content: data.description
                        }
                    ]
                }
            ]);
    });
};
