module.exports = function (bh) {
    bh.match('directors', function (ctx) {
        var data = {
            items: [
                {
                    name: 'John Boynton',
                    position: 'Non-executive Chairman of the Board of Directors',
                    description: 'John Boynton has been a non-executive director since 2000. In 2016 he has been appointed to serve as Chairman of the Board. Mr. Boynton is the president of Firehouse Capital Inc., a privately held investment company with investments in a variety of early stage companies. He also serves on the boards of several non-profit organizations. Mr. Boynton served as a founder and managing director of Wilson Alan LLC from 2001 through 2006, as vice president of corporate strategy and development at Forrester Research from 1997 to 2001, as a strategy consultant with Mercer Management Consulting from 1995 to 1997, and as co-founder and president of CompTek International from 1990 to 1995. Mr. Boynton graduated from Harvard College.'
                },
                {
                    name: 'Arkady Volozh',
                    position: 'Chief Executive Officer and Executive Director',
                    description: 'Arkady Volozh is the principal founder of Yandex and has been our Chief Executive Officer and a director since 2000. A serial entrepreneur with a background in computer science, Mr. Volozh co-founded several successful IT enterprises, including InfiNet Wireless, a Russian provider of wireless networking technology, and CompTek International, one of the largest distributors of network and telecom equipment in Russia. In 2000, Arkady left his position as CEO at CompTek International to become the CEO of Yandex. Mr. Volozh started working on search in 1989, which led to him establishing Arkadia Company in 1990, a company developing search software. His earlier achievements include the development of electronic search for use in patents, Russian classical literature and the Bible. Mr. Volozh holds a degree in applied mathematics from the Gubkin Institute of Oil and Gas.'
                },
                {
                    name: 'Charles Ryan',
                    position: 'Non-executive Director',
                    description: 'Charles Ryan became a non-executive director of Yandex upon the closing of our initial public offering. A finance professional with 22 years of experience in both the Russian and international markets, Mr. Ryan co-founded United Financial Group (UFG) and became its Chairman and CEO in 1994. In 1998, Mr. Ryan initiated the New Technology Group within UFG Asset Management, which sponsored an early-stage technology investment in ru-Net Holdings whose investments include Yandex. In 2006, Deutsche Bank acquired 100% of UFG\'s investment banking business, and Mr. Ryan was appointed chief country officer and CEO of Deutsche Bank Group in Russia and remained in that position until the end of 2008, when he became chairman of UFG Asset Management. From 2008 through the end of 2010, Mr. Ryan was a consultant for Deutsche Bank. Prior to founding UFG, Mr. Ryan worked as a financial analyst with CS First Boston from 1989 to 1991 and as an associate and principal banker with the European Bank for Reconstruction and Development in London from 1991 to 1994. Mr. Ryan has a degree in Government from Harvard University.'
                },
                {
                    name: 'Alexander Voloshin',
                    position: 'Non-executive Director',
                    description: 'Alexander Voloshin has been a non-executive director of Yandex since August 2010 after serving as an advisor to the company for two years. Since February 2012, Alexander Voloshin serves Chairman of Board and Independent Director at JSC Freight One. Mr. Voloshin also served as Chairman of the Board of Directors of Uralkali from 2010 to 2014. Prior to joining our Board of Directors, Mr. Voloshin served as Chairman of the Board of MMC Norilsk Nickel from 2008 to 2010 and as Chairman of the Board of Directors of RAO "UES of Russia" from 1999 to 2008. From 1999 to 2003 Mr. Voloshin headed the Russian Presidential Administration. Prior to becoming Chief of Staff of the Russian President he worked as Deputy Chief of Staff from 1998 to1999, and as Assistant to Chief of Staff from 1997 to 1998. He graduated from the Moscow Institute of Transport Engineers in 1978 and holds a degree in economics from the All-Russia Foreign Trade Academy.'
                },
                {
                    name: 'Herman Gref',
                    position: 'Non-executive Director',
                    description: 'Herman Gref has served since 2007 as the Chief Executive Officer and Chairman of the Executive Board of Sberbank of Russia, one of the largest commercial banks in Russia. From 2000 to 2007, Mr. Gref was the Minister for Economic Development of the Russian Federation. He previously served in a number of government positions at the federal and regional levels in Russia. Mr. Gref received a degree in law from Omsk State University in 1990, a Ph.D. in law from St. Petersburg State University in 1993 and has a Ph.D. in economics. Mr. Gref holds a Citation and Certificate of Honor from the President of the Russian Federation, the Order for Distinguished Service of Grade IV and the Stolypin Medal.'
                },
                {
                    name: 'Rogier Rijnja',
                    position: 'Non-executive Director',
                    description: 'Mr. Rijnja, age 50, is Senior Vice President of Human Resources and a member of the executive committee at D.E Master Blenders, a Dutch public company listed on the Amsterdam stock exchange. Prior to joining D.E Master Blenders in 2011, Mr. Rijnja served as head of the human resources departments at several international companies, including Maxeda (2008 to 2011), Numico N.V. (2004 to 2008) and Amazon.com (2002 to 2004). He was previously the director of global management development at Reckitt Benckiser PLC from 1998 to 2002, and a human resources manager for Nike Europe from 1996 to 1998. Mr. Rijnja held several positions at Apple between 1989 and 1996 in The Netherlands and the United States. Mr. Rijnja has a degree in law studies from Leiden University in The Netherlands.'
                },
                {
                    name: 'Esther Dyson',
                    position: 'Non-executive Director',
                    description: 'Esther Dyson has been our non-executive director since 2006. Ms. Dyson is the executive founder of HICCup, a US nonprofit dedicated to the production of health and the demonstration of its financial feasibility through a five-community project called the Way to Wellville. Ms. Dyson is an active investor and board member in a variety of IT, health care and aerospace start-ups, and also sits on the board of Luxoft, another IT company of Russian origin. She started her career as a fact-checker for Forbes Magazine, and then spent five years as a securities analyst on Wall Street. At New Court Securities, Ms. Dyson comprised the sell-side research department, and worked on the initial public offering of Federal Express, among others. At Oppenheimer & Co., she followed the nascent software and personal computer markets. From 1982 to 2004, as the owner of EDventure Holdings, she edited its newsletter Release 1.0 and ran its annual PC Forum conference. She sold EDventure to CNET in 2004, and reclaimed the name when she left CNET at the beginning of 2007. In addition to Yandex and Luxoft, her Russian interests have included advisory board seats with both IBS Group and SUP/Live Journal, and investments in the technology companies Epam, Ostrovok, TerraLink, UCMS and Zingaya. In the U.S., she sits on the boards of 23andMe, Meetup, Voxiva, XCOR Aerospace and others. She was an early investor in Flickr and del.icio.us (sold to Yahoo!), Medstory and Powerset (sold to Microsoft), Brightmail (sold to Symantec), and Postini (sold to Google), among others. She is the author of “Release 2.0: A design for living in the digital age” (1997), which has been translated into 18 languages. She earned a B.A. in economics from Harvard University.'
                }
            ]
        };

        var docsList = [
            { title: 'Audit Committee Charter', type: 'pdf', url: '#' },
            { title: 'Compensation Committee Charter', type: 'pdf', url: '#' },
            { title: 'Nominating and Corporate', type: 'pdf', url: '#' },
            { title: 'Governance Committee Charter', type: 'pdf', url: '#' },
            { title: 'Investment Committee Charter', type: 'webcast', url: '#' }
        ];

        ctx
            .content([
                {
                    block: 'page-title',
                    content: 'Board of Directors'
                },
                {
                    elem: 'list',
                    content: getItems(data.items)
                },
                {
                    block: 'text',
                    tag: 'p',
                    content: [
                        'The Board of Directors has established four principal committees which are ',
                        'the Audit Committee, the Compensation Committee, the Nominating and Corporate ',
                        'Governance Committee and the Investment Committee. Copies of each of the committees ',
                        'charters are available below:'
                    ]
                },
                {
                    block: 'docs-list',
                    docsList: docsList
                },
                {
                    block: 'governance-docs'
                }
            ]);
    });

    function getItems(items) {
        return items.map(function (item) {
            return {
                elem: 'line',
                content: {
                    block: 'director',
                    item: item
                }
            };
        });
    }
};
