module.exports = function (bh) {
    bh.match('docs-list', function (ctx) {
        ctx
            .tag('ul')
            .content(getItems(ctx.param('docsList')));
    });

    function getItems(docs) {
        return docs.map(function (doc) {
            return {
                elem: 'item',
                tag: 'li',
                content: {
                    elem: 'link',
                    tag: 'a',
                    attrs: {
                        href: doc.url
                    },
                    content: {
                        elem: 'inner',
                        content: [
                            {
                                block: 'icon',
                                mods: {
                                    view: 'doc',
                                    type: doc.type
                                }
                            },
                            {
                                elem: 'title',
                                tag: 'span',
                                content: doc.title + '&#32;'
                            },
                            doc.size && {
                                elem: 'size',
                                tag: 'span',
                                content: doc.size
                            }
                        ]
                    }
                }
            };
        });
    }
};
