module.exports = function (bh) {
    bh.match('financial-release', function (ctx) {
        var docsList = [
            { title: 'Webcast', type: 'webcast', url: '#' },
            { title: 'Slides (pptx)', type: 'pptx', url: '#' },
            { title: 'Transcript (pdf)', type: 'pdf', url: '#' }
        ];

        ctx
            .mix({ block: 'text' })
            .content([
                {
                    elem: 'breadcrumb',
                    mix: {
                        block: 'text',
                        mods: {
                            size: 'l'
                        }
                    },
                    content: {
                        block: 'text',
                        elem: 'link',
                        tag: 'a',
                        content: 'Financial releases'
                    }
                },
                {
                    block: 'page-title',
                    content: 'Yandex Announces Third Quarter 2017 Financial Results'
                },
                {
                    block: 'docs-list',
                    mods: {
                        view: 'line'
                    },
                    docsList: docsList
                },
                {
                    elem: 'date',
                    content: 'July 28, 2017'
                },
                getContent(),
                {
                    block: 'button-page-action',
                    text: 'Go to IR homepage'
                }
            ]);
    });

    function getContent() {
        return {
            block: 'text',
            mods: {
                type: 'article'
            },
            content: [
                {
                    block: 'text',
                    tag: 'p',
                    content: [
                        'MOSCOW and AMSTERDAM, the Netherlands, Oct. 24, 2017 (GLOBE NEWSWIRE) —\n' +
                        'Yandex (NASDAQ:YNDX), one of Europe\'s largest internet companies and the leading search' +
                        ' provider in Russia, today announced its unaudited financial results for the third quarter ended September 30, 2017.'
                    ]
                },
                {
                    block: 'text',
                    tag: 'h2',
                    content: 'Q3 2017 Financial Highlights(1)(2)'
                },
                {
                    block: 'text',
                    tag: 'ul',
                    content: [
                        {
                            tag: 'li',
                            content: [
                                { tag: 'strong', content: 'Revenues' },
                                ' of RUB 23.4 billion ($404.0 million), up 21% compared with Q3 2016'
                            ]
                        },
                        {
                            tag: 'li',
                            content: [
                                {
                                    tag: 'strong',
                                    content: 'Net income'
                                },
                                ' of RUB&nbsp;0.9 billion ($14.7 million), down 65% compared with Q3 2016 net',
                                ' income margin of 3.6%'
                            ]
                        },
                        {
                            tag: 'li',
                            content: [
                                { tag: 'strong', content: 'Revenues' },
                                ' of RUB 23.4 billion ($404.0 million), up 21% compared with Q3 2016'
                            ]
                        },
                        {
                            tag: 'li',
                            content: [
                                {
                                    tag: 'strong',
                                    content: 'Net income'
                                },
                                ' of RUB&nbsp;0.9 billion ($14.7 million), down 65% compared with Q3 2016 net',
                                ' income margin of 3.6%'
                            ]
                        }
                    ]
                },
                {
                    block: 'text',
                    tag: 'p',
                    content: [
                        '"This was another strong quarter with 21% revenue growth and significant ',
                        'increase in our search share on Android," said Arkady Volozh, Chief Executive',
                        ' Officer of Yandex. "I am also very excited about the recent launch of Alice, ',
                        'the first conversational intelligent assistant for the Russian market.  Alice is a',
                        ' great demonstration of how we can apply our expertise in AI, voice recognition',
                        ' and synthesis technology to create products that delight our consumers."'
                    ]
                },
                {
                    block: 'text',
                    tag: 'p',
                    content: [
                        '"I am very proud of the pace of innovations in our core business. In Q3 we',
                        'launched Korolyov, our new intelligent search algorithm, and introduced our Turbo',
                        ' technology, which significantly accelerates loading times of mobile sites,',
                        '" said" Alexander Shulgin, Chief Operating Officer of Yandex. "We continued',
                        ' to invest in our business units, including in regional expansion within',
                        ' Yandex.Taxi and our Classifieds segment."'
                    ]
                },
                {
                    tag: 'table',
                    content: [
                        {
                            tag: 'tbody',
                            content: [
                                {
                                    tag: 'tr',
                                    content: [
                                        {
                                            tag: 'td',
                                            content: 'In RUB millions'
                                        },
                                        {
                                            tag: 'td',
                                            attrs: {
                                                colspan: '3'
                                            },
                                            content: 'Three months ended September 30'
                                        },
                                        {
                                            tag: 'td',
                                            attrs: {
                                                colspan: '4'
                                            },
                                            content: 'Three months ended September 30'
                                        }
                                    ]
                                },
                                {
                                    tag: 'tr',
                                    content: [
                                        { tag: 'td', content: ' ' },
                                        { tag: 'td', content: '2016' },
                                        { tag: 'td', content: '2017' },
                                        { tag: 'td', content: 'Change' },
                                        { tag: 'td', content: '2016' },
                                        { tag: 'td', content: '2017' },
                                        { tag: 'td', content: 'Change' },
                                        { tag: 'td', content: 'Delta' }
                                    ]
                                },
                                {
                                    tag: 'tr',
                                    content: [
                                        { tag: 'td', content: 'Total online advertising revenues' },
                                        { tag: 'td', content: '19,293' },
                                        { tag: 'td', content: '23,438' },
                                        { tag: 'td', content: '21%' },
                                        { tag: 'td', content: '53,806' },
                                        { tag: 'td', content: '66,194' },
                                        { tag: 'td', content: '66,14' },
                                        { tag: 'td', content: '23%' }
                                    ]
                                },
                                {
                                    tag: 'tr',
                                    content: [
                                        { tag: 'td', content: 'Revenues' },
                                        { tag: 'td', content: '119,293' },
                                        { tag: 'td', content: '3,438' },
                                        { tag: 'td', content: '21%' },
                                        { tag: 'td', content: '253,806' },
                                        { tag: 'td', content: '266,194' },
                                        { tag: 'td', content: '266,14' },
                                        { tag: 'td', content: '123%' }
                                    ]
                                }
                            ]
                        }
                    ]
                },
                {
                    block: 'text',
                    tag: 'h3',
                    content: 'Consolidated Operating Costs and Expenses'
                },
                {
                    block: 'text',
                    tag: 'p',
                    content: [
                        '"I am very proud of the pace of innovations in our core business. In Q3 we',
                        'launched Korolyov, our new intelligent search algorithm, and introduced our Turbo',
                        ' technology, which significantly accelerates loading times of mobile sites,',
                        '" said" Alexander Shulgin, Chief Operating Officer of Yandex. "We continued',
                        ' to invest in our business units, including in regional expansion within',
                        ' Yandex.Taxi and our Classifieds segment."'
                    ]
                }
            ]
        };
    }
};
