$(window).on("DOMContentLoaded", function () {
    wrapTables();
    setWidthTables();
});

$(window).on("orientationchange resize", function () {
    setWidthTables();
});

function wrapTables() {
    $('.financial-release').each(function (i, elem) {
        var tables = elem.getElementsByTagName('table');

        $.each(tables, function (i, table) {
            $(table).wrap($('<div class="text__table"></div>'));
        });
    });
}

function setWidthTables() {
    $('.financial-release').each(function (i, elem) {
        var tables = elem.getElementsByTagName('table');

        $.each(tables, function (i, table) {
            var $wrapper = $(table).parent();
            var winW = window.innerWidth;
            var tableW = $(table)[0].clientWidth;
            var gap = 20;

            var width;
            if ((winW - 2 * gap) < tableW) {
                width = winW - gap;

                $wrapper.css({
                    width: width + 'px',
                    'margin-right': -gap + 'px'
                });
            }
        });
    });
}
