module.exports = function (bh) {
    bh.match('financial-releases', function (ctx) {
        var docsList = [
            { title: 'Webcast', type: 'webcast', url: '#' },
            { title: 'Slides (pptx)', type: 'pptx', url: '#' },
            { title: 'Transcript (pdf)', type: 'pdf', url: '#' }
        ];

        ctx
            .content([
                {
                    block: 'page-title',
                    content: 'Financial Releases'
                },
                {
                    elem: 'list',
                    tag: 'ul',
                    content: getListItems([
                        {
                            date: 'July 28, 2017',
                            title: 'Yandex Announces Second Quarter 2017 Financial Results',
                            docsList: docsList
                        },
                        {
                            date: 'July 1, 2017',
                            title: 'Yandex Announces Quarter 2017 Financial Results',
                            docsList: docsList
                        },
                        {
                            date: 'July 15, 2017',
                            title: 'Yandex Announces Financial Results',
                            docsList: docsList
                        },
                        {
                            date: 'July 5, 2017',
                            title: 'Yandex Announces Second Quarter 2017 Results',
                            docsList: docsList
                        }
                    ])
                },
                { block: 'button-page-action' }
            ]);
    });

    function getListItems(list) {
        return list.map(function (item) {
            return {
                elem: 'item',
                tag: 'li',
                content: [
                    {
                        block: 'date',
                        content: item.date
                    },
                    {
                        block: 'text',
                        tag: 'h2',
                        content: {
                            elem: 'link',
                            tag: 'a',
                            attrs: {
                                href: '#'
                            },
                            content: item.title
                        }
                    },
                    {
                        block: 'docs-list',
                        mods: {
                            view: 'line'
                        },
                        docsList: item.docsList
                    }
                ]
            };
        });
    }
};
