module.exports = function (bh) {
    bh.match('foot', function (ctx) {
        ctx
            .tag('footer')
            .content({
                elem: 'cols',
                content: [
                    {
                        elem: 'column',
                        mods: { slim: true },
                        content: {
                            elem: 'versions',
                            content: {
                                block: 'touch-switcher'
                            }
                        }
                    },
                    {
                        elem: 'column',
                        content: {
                            elem: 'link',
                            tag: 'a',
                            attrs: {
                                href: 'https://yandex.com/legal/',
                                target: '_blank'
                            },
                            content: 'Legal Documents'
                        }
                    },
                    {
                        elem: 'column',
                        mods: { wide: true },
                        content: {
                            elem: 'versions',
                            content: [
                                { elem: 'link', tag: 'a', attrs: { href: 'https://yandex.ru/company', target: '_blank' }, content: 'Ru' },
                                { elem: 'link', tag: 'a', attrs: { href: 'https://yandex.ua/company', target: '_blank' }, content: 'Ua' },
                                { elem: 'link', tag: 'a', attrs: { href: 'https://yandex.com.tr/company', target: '_blank' }, content: 'Tr' }
                            ]
                        }
                    },
                    {
                        elem: 'column',
                        mods: { right: true },
                        content: {
                            block: 'copyright',
                            content: [
                                '&copy;&nbsp;1997&ndash;2017&nbsp;&nbsp;',
                                {
                                    elem: 'link',
                                    tag: 'a',
                                    attrs: { href: 'http://www.yandex.com' },
                                    content: 'Yandex'
                                }
                            ]
                        }
                    }
                ]
            });
    });

    bh.match('touch-switcher', function (ctx) {
        ctx.content([
            {
                elem: 'label',
                tag: 'span',
                content: 'com'
            },
            {
                elem: 'select',
                tag: 'select',
                content: [
                    { elem: 'option', tag: 'option', attrs: { value: 'https://yandex.com/company' }, content: 'Com' },
                    { elem: 'option', tag: 'option', attrs: { value: 'https://yandex.ru/company' }, content: 'Ru' },
                    { elem: 'option', tag: 'option', attrs: { value: 'https://yandex.ua/company' }, content: 'Ua' },
                    { elem: 'option', tag: 'option', attrs: { value: 'https://yandex.com.tr/sirket/' }, content: 'Tr' }
                ]
            }
        ]);
    });
};
