module.exports = function (bh) {
    bh.match('form-ask', function (ctx) {
        ctx
            .tag('form')
            .mix({ block: 'form' })
            .content([
                {
                    block: 'text',
                    tag: 'p',
                    content: 'Questions for the Investor Relations Department can be submitted through the form below.'
                },
                {
                    block: 'form',
                    elem: 'fields',
                    content: [
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Name' },
                                { elem: 'control' },
                                {
                                    elem: 'message',
                                    elemMods: { type: 'error', visibility: 'visible' },
                                    content: 'Example for error'
                                }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Email' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Subject' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm', type: 'textarea' },
                            content: [
                                { elem: 'label', content: 'Comments' },
                                { elem: 'control',
                                    attrs: { rows: '3' }
                                }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Type in number' },
                                { elem: 'control' }
                            ]
                        }
                    ]
                },
                {
                    block: 'form',
                    elem: 'actions',
                    content: [
                        {
                            block: 'form',
                            elem: 'captcha',
                            content: {
                                tag: 'img',
                                attrs: {
                                    src: 'http://apps.shareholder.com/captcha/captcha.aspx?verifyid=2029055991&CompanyID=YNDX&t=.jpg'
                                }
                            }
                        },
                        {
                            block: 'text',
                            mods: { note: true },
                            content: 'This helps Yandex prevent automated submissions.'
                        },
                        {
                            block: 'form',
                            elem: 'button',
                            content: {
                                block: 'button2',
                                mods: {
                                    theme: 'action',
                                    size: 'n',
                                    view: 'default',
                                    tone: 'default'
                                },
                                text: 'Submit'
                            }
                        }
                    ]
                }
            ]);
    });
};
