module.exports = function (bh) {
    bh.match('form', function (ctx) {
        ctx
            .tag('form')
            .content([
                {
                    block: 'text',
                    tag: 'p',
                    content: 'You may automatically receive Yandex financial information by email. Please enter your' +
                    ' preferences for email notifications below.'
                },
                {
                    elem: 'fields',
                    content: [
                        {
                            elem: 'checkboxes',
                            content: [
                                {
                                    elem: 'label',
                                    content: 'Press Releases'
                                },
                                {
                                    elem: 'checkboxes-content',
                                    content: [
                                        {
                                            elem: 'checkbox',
                                            content: {
                                                block: 'checkbox',
                                                mods: { theme: 'normal', view: 'default', tone: 'default', size: 'm' },
                                                text: 'Financial Releases'
                                            }
                                        },
                                        {
                                            elem: 'checkbox',
                                            content: {
                                                block: 'checkbox',
                                                mods: { theme: 'normal', view: 'default', tone: 'default', size: 'm' },
                                                text: 'All'
                                            }
                                        },
                                        {
                                            elem: 'checkbox',
                                            content: {
                                                block: 'checkbox',
                                                mods: { theme: 'normal', view: 'default', tone: 'default', size: 'm' },
                                                text: 'Announcements'
                                            }
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'First Name' },
                                { elem: 'control' },
                                {
                                    elem: 'message',
                                    elemMods: { type: 'error', visibility: 'visible' },
                                    content: 'Example for error'
                                }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Last Name' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Email' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Title' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Company' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            elem: 'select',
                            content: [
                                {
                                    elem: 'label',
                                    content: 'Investor Type'
                                },
                                {
                                    block: 'select-adaptive',
                                    content: {
                                        block: 'select2',
                                        mods: { native: 'yes', theme: 'normal', view: 'default', tone: 'default', size: 'm', text: 'vary', type: 'radio' },
                                        name: 'investor-type-adaptive',
                                        control: {
                                            elem: 'control',
                                            elemMods: { native: 'yes' }
                                        },
                                        items: getTypeItems()
                                    }
                                },
                                {
                                    block: 'select-desktop',
                                    content: {
                                        block: 'select2',
                                        mods: { theme: 'normal', tone: 'default', view: 'default', size: 'm', type: 'radio', text: 'vary' },
                                        name: 'investor-type',
                                        control: true,
                                        items: getTypeItems()
                                    }
                                }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm' },
                            content: [
                                { elem: 'label', content: 'Type in number' },
                                { elem: 'control' }
                            ]
                        },
                        {
                            block: 'input',
                            mods: { size: 'm', disabled: 'yes' },
                            content: [
                                { elem: 'label', content: 'Input disable example' },
                                { elem: 'control' }
                            ]
                        }
                    ]
                },
                {
                    elem: 'actions',
                    content: [
                        {
                            elem: 'captcha',
                            content: {
                                tag: 'img',
                                attrs: {
                                    src: 'http://apps.shareholder.com/captcha/captcha.aspx?verifyid=2029055991&CompanyID=YNDX&t=.jpg'
                                }
                            }
                        },
                        {
                            block: 'text',
                            mods: { note: true },
                            content: 'This helps Yandex prevent automated submissions.'
                        },
                        {
                            elem: 'button',
                            content: {
                                block: 'button2',
                                mods: {
                                    theme: 'action',
                                    size: 'n',
                                    view: 'default',
                                    tone: 'default'
                                },
                                text: 'Submit'
                            }
                        }
                    ]
                }
            ]);
    });

    function getTypeItems() {
        return [
            { val: '', text: 'Select type' },
            { val: 'Individual Investor', text: 'Individual Investor' },
            { val: 'Equity Analyst (sell-side)', text: 'Equity Analyst (sell-side)' },
            { val: 'Equity Analyst (buy-side)', text: 'Equity Analyst (buy-side)' },
            { val: 'Fixed Income Analyst (sell-side)', text: 'Fixed Income Analyst (sell-side)' },
            { val: 'Portfolio Manager (Equity)', text: 'Portfolio Manager (Equity)' },
            { val: 'Portfolio Manager (Fixed Income)', text: 'Portfolio Manager (Fixed Income)' },
            { val: 'Broker/Investment Advisor', text: 'Broker/Investment Advisor' },
            { val: 'Banker/Financing Source', text: 'Banker/Financing Source' },
            { val: 'Press/Media', text: 'Press/Media' },
            { val: 'Consultant', text: 'Consultant' },
            { val: 'Employee', text: 'Employee' },
            { val: 'Customer/Client', text: 'Customer/Client' },
            { val: 'Library/Reference', text: 'Library/Reference' },
            { val: 'Student', text: 'Student' },
            { val: 'Other', text: 'Other' }
        ];
    }
};
