module.exports = function (bh) {
    bh.match('governance-docs', function (ctx) {
        var docsList = [
            { title: 'Articles of Association', size: '(English, PDF 2 mb)', type: 'pdf', url: '#' },
            { title: 'Articles of Association', size: '(Dutch, PDF 2,4 mb)', type: 'pdf', url: '#' },
            { title: 'Code of Business Ethics and Conduct', size: '(PDF 187,6 kb)', type: 'pdf', url: '#' },
            { title: 'Corporate Governance Guidelines', size: '(PDF 40,3 kb)', type: 'pdf', url: '#' },
            { title: 'Insider Trading Policy', size: '(PDF 310,4 kb)', type: 'pdf', url: '#' }
        ];

        ctx.content([
            {
                block: 'page-title',
                content: 'Corporate Governance Documents'
            },
            {
                block: 'text',
                tag: 'p',
                content: [
                    'Copies of our Articles of Association, Code of Business Ethics and Conduct, ',
                    'Corporate Governance Guidelines and Insider Trading Policy are available below:'
                ]
            },
            {
                block: 'docs-list',
                docsList: docsList
            }
        ]);
    });
};
