module.exports = function (bh) {
    bh.match('head', function (ctx) {
        ctx
            .tag('header')
            .js(true)
            .content([
                {
                    block: 'logo',
                    mix: { block: 'head', elem: 'logo' },
                    content: {
                        elem: 'link',
                        tag: 'a',
                        attrs: {
                            href: 'https://yandex.com'
                        },
                        content: 'Yandex'
                    }
                },
                {
                    elem: 'container',
                    content: [
                        {
                            elem: 'pannel',
                            mods: { active: 'yes' },
                            content: getServices([
                                { href: 'https://yandex.com/company', text: 'Company' },
                                { href: 'https://yandex.com/jobs', text: 'Jobs' },
                                { href: 'https://tech.yandex.com', text: 'For Developers' },
                                { href: 'https://yandex.com/adv', text: 'For Advertisers' },
                                { href: 'https://ir.yandex', text: 'For Investors' }
                            ])
                        },
                        {
                            elem: 'pannel',
                            content: getServices([
                                { href: 'https://events.yandex.com/events', text: 'Events' },
                                { href: 'https://research.yandex.com', text: 'Research' }
                            ])
                        }
                    ]
                },
                {
                    elem: 'nav',
                    content: {
                        elem: 'menu'
                    }
                }
            ]);
    });

    function getServices(list) {
        return list.map(function (item) {
            return {
                elem: 'service',
                tag: 'a',
                mods: {
                    active: item.text === 'For Investors'
                },
                attrs: { href: item.href },
                content: item.text
            };
        });
    }
};
