module.exports = function (bh) {
    bh.match('list', function (ctx) {
        var items = ctx.param('items');
        var docsView = ctx.param('docsView');

        ctx.content(getItems(items, docsView));
    });

    function getItems(items, docsView) {
        return items.map(function (item) {
            return {
                elem: 'line',
                mods: item.active && {
                    active: true
                },
                content: [
                    {
                        elem: 'left',
                        content: {
                            block: 'date',
                            content: item.date
                        }
                    },
                    {
                        elem: 'right',
                        content: [
                            {
                                block: 'text',
                                tag: 'h3',
                                content: item.content.title
                            },
                            item.content.location && {
                                block: 'text',
                                content: 'Location: ' + item.content.location
                            },
                            item.content.docsList && {
                                block: 'docs-list',
                                mods: docsView && {
                                    view: docsView
                                },
                                docsList: item.content.docsList
                            }
                        ]
                    }
                ]
            };
        });
    }
};
