BEM.DOM.decl('map-content', {
    onSetMod: {
        js: function () {
            ymaps.ready($.proxy(this.initMap, this));
        }
    },

    initMap: function initMap() {
        var mapData = this.params.map;

        var map = new ymaps.Map(this.elem('map').get(0), {
            center: [mapData.latitude, mapData.longitude],
            zoom: mapData.zoom || 16,
            controls: ['zoomControl', 'fullscreenControl']
        });

        var placemark = new ymaps.Placemark(
            [mapData.latitude, mapData.longitude],
            {},
            { preset: 'islands#redDotIcon' }
        );

        map.geoObjects.add(placemark);
    }
});
