module.exports = function (bh) {
    bh.match('nav', function (ctx) {
        ctx
            .tag('nav')
            .content({
                elem: 'panel',
                content: [
                    { elem: 'close' },
                    {
                        elem: 'inner',
                        content: [
                            { block: 'services' },
                            {
                                elem: 'site-menu',
                                content: {
                                    block: 'site-menu',
                                    content: {
                                        elem: 'menu',
                                        content: {
                                            elem: 'nav',
                                            content: getServices('link', [
                                                { href: '#', text: 'Financial Releases' },
                                                { href: 'https://yandex.com/company/press_center/press_releases', text: 'Company News' },
                                                { href: '#', text: 'Events' },
                                                { href: '#', text: 'Annual Meeting' },
                                                { href: '#', text: 'SEC Filings' },
                                                { href: '#', text: 'Stock Data' },
                                                { href: '#', text: 'Analyst Coverage' },
                                                { href: '#', text: 'Corporate Governance' }
                                            ])
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            });
    });

    bh.match('services', function (ctx) {
        ctx.content({
            block: 'scroller',
            content: {
                elem: 'wrap',
                content: {
                    elem: 'items',
                    content: {
                        block: 'menu-services',
                        content: getServices('item', [
                            { href: 'https://ir.yandex', text: 'For Investors' },
                            { href: 'https://yandex.com/company', text: 'Company' },
                            { href: 'https://yandex.com/jobs', text: 'Jobs' },
                            { href: 'https://tech.yandex.com', text: 'For Developers' },
                            { href: 'https://yandex.com/adv', text: 'For Advertisers' },
                            { href: 'https://events.yandex.com/events', text: 'Events' },
                            { href: 'https://research.yandex.com', text: 'Research' }
                        ])
                    }
                }
            }
        });
    });

    function getServices(elemName, list) {
        return list.map(function (item) {
            return {
                elem: elemName,
                tag: 'a',
                mods: {
                    active: item.text === 'For Investors' || item.text === 'Financial Releases'
                },
                attrs: { href: item.href },
                content: item.text
            };
        });
    }
};
