module.exports = function (bh) {
    bh.match('sec-filings', function (ctx) {
        ctx
            .content([
                {
                    block: 'page-title',
                    content: 'SEC Filings'
                },
                {
                    elem: 'filters'
                },
                {
                    elem: 'content'
                },
                { block: 'button-page-action' }
            ]);
    });

    bh.match('sec-filings__filters', function (ctx) {
        ctx
            .content([
                {
                    block: 'select-adaptive',
                    content: [
                        {
                            block: 'select2',
                            mods: { native: 'yes', theme: 'normal', view: 'default', tone: 'default', size: 'm', text: 'vary', type: 'radio' },
                            name: 'filings-adaptive',
                            control: {
                                elem: 'control',
                                elemMods: { native: 'yes' }
                            },
                            items: getItemsFilings()
                        },
                        {
                            block: 'select2',
                            mods: { native: 'yes', theme: 'normal', view: 'default', tone: 'default', size: 'm', text: 'vary', type: 'radio' },
                            name: 'years-adaptive',
                            control: {
                                elem: 'control',
                                elemMods: { native: 'yes' }
                            },
                            items: getItemsYear()
                        }
                    ]
                },
                {
                    block: 'select-desktop',
                    content: [
                        {
                            block: 'select2',
                            mods: { theme: 'normal', tone: 'default', view: 'default', size: 'm', type: 'radio', text: 'vary' },
                            name: 'filings',
                            control: true,
                            items: getItemsFilings()
                        },
                        {
                            block: 'select2',
                            js: true,
                            mods: { theme: 'normal', tone: 'default', view: 'default', size: 'm', type: 'radio', text: 'vary' },
                            name: 'years',
                            control: true,
                            items: getItemsYear()
                        }
                    ]
                }
            ]);
    });

    function getItemsYear() {
        return [
            { val: '', text: 'All Years' },
            { val: '2018', text: '2018' },
            { val: '2017', text: '2017' },
            { val: '2016', text: '2016' },
            { val: '2015', text: '2015' },
            { val: '2014', text: '2014' },
            { val: '2013', text: '2013' },
            { val: '2012', text: '2012' },
            { val: '2011', text: '2011' }
        ];
    }

    function getItemsFilings() {
        return [
            { val: '', text: 'All Filings' },
            { val: 'Annual', text: 'Annual' },
            { val: 'Quarterly', text: 'Quarterly' },
            { val: 'Current', text: 'Current' },
            { val: 'Section16', text: 'Section 16' },
            { val: 'Proxy', text: 'Proxy' },
            { val: 'Other', text: 'Other' }
        ];
    }

    bh.match('sec-filings__content', function (ctx) {
        var data = [
            {
                filing: '6-K',
                title: 'Automatic Shelf Registration Statement Of Securities Of Well-Known Seasoned Issuers',
                url: '#',
                date: 'September 15, 2018',
                docsList: [{ title: 'HTML', type: 'code', url: '#' }, { title: 'PPTX', type: 'pptx', url: '#' }, { title: 'PDF', type: 'pdf', url: '#' }]
            },
            {
                filing: '20-F',
                title: 'Annual Report For Foreign Private Issuers',
                url: '#',
                date: 'March 22, 2017',
                docsList: [{ title: 'HTML', type: 'code', url: '#' }, { title: 'PPTX', type: 'pptx', url: '#' }, { title: 'PDF', type: 'pdf', url: '#' }, { title: 'XBRL', type: 'xbrl', url: '#' }]
            },
            {
                filing: 'CT ORDER',
                title: 'Amended General Statement Of Beneficial Ownership',
                url: '#',
                date: 'March 22, 2017',
                docsList: [{ title: 'HTML', type: 'code', url: '#' }, { title: 'PPTX', type: 'pptx', url: '#' }]
            },
            {
                filing: '20-F',
                title: 'Annual Report ',
                url: '#',
                date: 'December 22, 2017',
                docsList: [{ title: 'HTML', type: 'code', url: '#' }, { title: 'PPTX', type: 'pptx', url: '#' }, { title: 'PDF', type: 'pdf', url: '#' }, { title: 'XBRL', type: 'xbrl', url: '#' }]
            },
            {
                filing: 'CT ORDER',
                title: 'Amended General Statement',
                url: '#',
                date: 'February 22, 2017',
                docsList: [{ title: 'HTML', type: 'code', url: '#' }]
            }
        ];

        ctx
            .content({
                elem: 'table',
                mix: [
                    { block: 'nirtable' }
                ],
                tag: 'table',
                content: [
                    {
                        tag: 'thead',
                        content: [
                            {
                                tag: 'th',
                                mods: {
                                    type: 'filing',
                                    sorted: 'down'
                                },
                                content: {
                                    block: 'text',
                                    mods: {
                                        size: 's'
                                    },
                                    content: [
                                        {
                                            block: 'sec-filings',
                                            elem: 'text-sort',
                                            content: 'Sort by:&#32;'
                                        },
                                        {
                                            elem: 'link',
                                            tag: 'a',
                                            attrs: {
                                                href: '#'
                                            },
                                            content: 'Filing'
                                        }
                                    ]
                                }
                            },
                            {
                                tag: 'th',
                                content: {
                                    block: 'text',
                                    mods: {
                                        size: 's'
                                    },
                                    content: {
                                        elem: 'link',
                                        tag: 'a',
                                        attrs: {
                                            href: '#'
                                        },
                                        content: 'Description'
                                    }
                                }
                            },
                            {
                                tag: 'th',
                                mods: {
                                    type: 'date',
                                    sorted: 'up'
                                },
                                mix: {
                                    block: 'views-field-field-nir-sec-date-filed'
                                },
                                content: {
                                    block: 'text',
                                    mods: {
                                        size: 's'
                                    },
                                    content: {
                                        elem: 'link',
                                        tag: 'a',
                                        attrs: {
                                            href: '#'
                                        },
                                        content: 'Date Filed'
                                    }
                                }
                            }
                        ]
                    },
                    {
                        tag: 'tbody',
                        content: getRows(data)
                    }
                ]
            });
    });

    function getRows(data) {
        return data.map(function (item) {
            return {
                tag: 'tr',
                content: [
                    {
                        tag: 'td',
                        content: item.filing
                    },
                    {
                        tag: 'td',
                        mix: {
                            block: 'view-field-nir-sec-description-table-column'
                        },
                        content: [
                            {
                                tag: 'a',
                                attrs: {
                                    href: '#'
                                },
                                content: {
                                    tag: 'p',
                                    content: item.title
                                }
                            },
                            {
                                block: 'docs-list',
                                mods: {
                                    view: 'line'
                                },
                                docsList: item.docsList
                            }
                        ]
                    },
                    {
                        tag: 'td',
                        content: {
                            block: 'date',
                            content: item.date
                        }
                    }
                ]
            };
        });
    }
};
