module.exports = function (bh) {
    bh.match('site-menu', function (ctx) {
        ctx
            .tag('nav')
            .content({
                elem: 'menu',
                content: {
                    elem: 'nav',
                    content: getMenuItems([
                        { href: '#', text: 'Financial Releases' },
                        { href: 'https://yandex.com/company/press_center/press_releases', text: 'Company News' },
                        { href: '#', text: 'Events' },
                        { href: '#', text: 'Annual Meeting' },
                        { href: '#', text: 'SEC Filings' },
                        { href: '#', text: 'Stock Data' },
                        { href: '#', text: 'Analyst Coverage' },
                        { href: '#', text: 'Corporate Governance' }
                    ])
                }
            });
    });

    function getMenuItems(list) {
        return list.map(function (item) {
            return {
                elem: 'link',
                tag: 'a',
                mods: {
                    active: item.text === 'Financial Releases'
                },
                attrs: { href: item.href },
                content: item.text
            };
        });
    }
};
