module.exports = function (bh) {
    bh.match('stock-data', function (ctx) {
        var stockData = [
            {
                row: [
                    { value: '0.46&nbsp;&#8593; (1.095%)', valueState: 'up', title: 'Change' },
                    { value: '0.00', title: 'Open' }
                ]
            },
            {
                row: [
                    { value: 'N/A', title: 'Day High' },
                    { value: '44.49', title: '52-Week High' }
                ]
            },
            {
                row: [
                    { value: '3,050&nbsp;&#8595;', valueState: 'down', title: 'Volume' },
                    { value: '42.00', title: 'Previous Close' }
                ]
            },
            {
                row: [
                    { value: 'N/A', title: 'Day Low' },
                    { value: '21.40', title: '52-Week Low' }
                ]
            }
        ];

        ctx
            .content([
                {
                    block: 'page-title',
                    content: 'Stock Data'
                },
                {
                    elem: 'info',
                    content: {
                        block: 'text',
                        mods: { tip: true },
                        content: {
                            block: 'stock-data',
                            elem: 'company',
                            tag: 'span',
                            content: [
                                'Yandex (NASDAQ: YNDX)',
                                '&#32;',
                                {
                                    block: 'stock-data',
                                    elem: 'date',
                                    tag: 'span',
                                    content: '4:15 PM ET on February 26, 2018'
                                }
                            ]
                        }
                    }
                },
                {
                    block: 'stock',
                    stockData: stockData
                },
                {
                    block: 'text',
                    tag: 'p',
                    content: [
                        'The Adobe Flash player is required to view the stock chart. The player can be downloaded for free from the ',
                        {
                            tag: 'a',
                            attrs: { href: '#' },
                            content: 'Adobe website'
                        },
                        '. If you prefer to not install this plugin, ',
                        {
                            tag: 'a',
                            attrs: { href: '#' },
                            content: 'click here'
                        },
                        ' to view the non-flash stock chart.'
                    ]
                },
                {
                    elem: 'email',
                    content: {
                        elem: 'email-link',
                        tag: 'a',
                        attrs: {
                            href: '#'
                        },
                        content: [
                            {
                                block: 'icon',
                                mods: {
                                    view: 'doc',
                                    type: 'mail'
                                }
                            },
                            {
                                elem: 'title',
                                tag: 'span',
                                content: 'Sign up for email alerts'
                            }
                        ]
                    }
                },
                {
                    block: 'text',
                    tag: 'p',
                    mods: { note: true },
                    content: [
                        'The stock information provided is for informational purposes only and is not intended for trading ',
                        'purposes. The stock information is provided by eSignal, stock charts are provided by NASDAQ',
                        'OMX, both third party services, and Yandex does not maintain or provide information',
                        ' directly to this service. Stock information is delayed approximately 20 minutes.'
                    ]
                }
            ]);
    });
};
