module.exports = function (bh) {
    bh.match('stock', function (ctx) {
        ctx
            .content([
                {
                    elem: 'left',
                    content: {
                        elem: 'price-box',
                        content: [
                            {
                                elem: 'last-price',
                                content: '42.51'
                            },
                            {
                                block: 'text',
                                mods: { note: true },
                                content: 'Last Price'
                            }
                        ]
                    }
                },
                {
                    elem: 'right',
                    content: {
                        elem: 'table',
                        stockData: ctx.param('stockData')
                    }
                }
            ]);
    });

    bh.match('stock__table', function (ctx) {
        ctx.content(getRows(ctx.param('stockData')));
    });

    function getRows(data) {
        return data.map(function (row) {
            var item = row.row.map(function (item) {
                return {
                    elem: 'item',
                    content: {
                        elem: 'item-inner',
                        content: [
                            {
                                elem: 'value',
                                mods: item.valueState && {
                                    state: item.valueState //'up' or 'down'
                                },
                                content: item.value  //for arrow: &#8593; or &#8595;
                            },
                            {
                                block: 'text',
                                mods: { note: true },
                                content: item.title
                            }
                        ]
                    }
                };
            });

            return {
                elem: 'row',
                content: item
            };
        });
    }
};
