import time
import threading
import logging

from source.safe_schedule import SafeScheduler

import source.equipment_monitoring.check_empty_oebs_login as check_empty_oebs_login
import source.equipment_monitoring.check_asset_without_owner as check_asset_without_owner
from source.equipment_monitoring.scheduler import jobs_equipment_monitoring


from source.ext_auto import need_info_closer
import source.kraken as kraken
from source.abuse import start_check_abuse
import source.vpnrobot as vpnrobot
from source.dismissal_pinger import mark_and_ping, find_without_hw

from source.cmdb.scheduler import jobs_cmdb
from source.software_monitoring.scheduler import jobs_software_monitoring
from source.monitoring.scheduler import jobs_monitoring
from source.queue_auto.scheduler import jobs_queue_auto

logger = logging.getLogger(__name__)

scheduler = SafeScheduler()

def run_threaded(job_func):
    job_thread = threading.Thread(target=job_func)
    job_thread.start()

scheduler.every().day.at("9:00").do(run_threaded, need_info_closer)
scheduler.every().day.at("12:15").do(run_threaded, kraken.main)
scheduler.every().day.at("10:00").do(run_threaded, mark_and_ping)
scheduler.every().day.at("10:00").do(run_threaded, find_without_hw)
scheduler.every().day.at("17:00").do(run_threaded, mark_and_ping)
scheduler.every().day.at("17:00").do(run_threaded, find_without_hw)
scheduler.every(10).minutes.do(run_threaded, start_check_abuse)

#QueueAuto
scheduler.every(1).hours.do(run_threaded, vpnrobot.main)

scheduler.jobs.extend(jobs_equipment_monitoring)
scheduler.jobs.extend(jobs_software_monitoring)
scheduler.jobs.extend(jobs_cmdb)
scheduler.jobs.extend(jobs_monitoring)
scheduler.jobs.extend(jobs_queue_auto)

while True:
    scheduler.run_pending()
    time.sleep(1)


