# -*- coding: utf-8 -*-
import requests
import json
import paramiko
import re
import logging
from source.config import *
from source.utils import exc_thread_wrapper
from datetime import datetime, timedelta
import urllib3
urllib3.disable_warnings()

logger = logging.getLogger(__name__)

def get_ticket_field(start_tag, end_tag, descr):
    ex = "&lt;"
    return descr[descr.find(start_tag): descr.find(end_tag)][len(start_tag):].replace(ex, '').replace('<', '')

def log_str_parser(list_strings):
    result = []
    for str in list_strings:
        data = re.search('\w+ \d+ \d+:\d+:\d+', str).group(0)
        loginAndType = re.search(' [\w\-]+\.\w+ ', str).group(0)
        result.append(data + loginAndType)
    return  result

def check_logs(ip_address, timeStamp, ssh_client):
    try:
        target_date = datetime.strptime(re.search(r"\d+-\d+-\d+\w\d+:\d+:\d+\w", timeStamp).group(0),
                                       '%Y-%m-%dT%H:%M:%SZ') + timedelta(hours=3)
    except ValueError:
        return 'Error: invalid format date'

    try:
        ip_address = re.search(r'^\d{1,3}.\d{1,3}.\d{1,3}.\d{1,3}$', ip_address).group(0)
    except AttributeError:
        return 'Ip Address invalid'

    curent_date = datetime.now().replace(microsecond=0)
    delta_date = (curent_date.replace(hour=0, minute=0, second=0) - target_date.replace(hour=0, minute=0, second=0)).days

    if delta_date in range(0, 9):
        stdin1, stdout1, stderr1 = ssh_client.exec_command(requestString(delta_date, ip_address))
        stdin2, stdout2, stderr2 = ssh_client.exec_command(requestString(delta_date + 1, ip_address))
        list_users = log_str_parser(stdout1.readlines() + stdout2.readlines())
    else:
        return ["Old date", 'none']
    if not list_users:
        return ["Not found users for IP %s" % ip_address, 'none']
    else:
        list_users = sort_grep_output(list_users, target_date)
        str_out = '<{Full history by 24 hours for ip %s:\n#|\n' % ip_address
        for user in list_users:
            str_out += '|| {date} | {time} | {user}@ ||\n'.format(date=user[0].strftime('%b %d'),
                                                                  time=user[0].strftime('%H:%M:%S'),
                                                                  user=user[1]
                                                                  )
        str_out += '|#}}>\n\nFinal result: {date} {time} {user}@'.format(date=list_users[-1][0].strftime('%b %d'),
                                                                        time=list_users[-1][0].strftime('%H:%M:%S'),
                                                                        user=list_users[-1][1]
                                                                        )
        str_out = [str_out, list_users[-1][2], list_users[-1][1]]
    return str_out

def sort_grep_output(log_list, target_date):
    result = []
    for line in log_list:
        date = datetime.strptime(re.search('\w+ \d+ \d+:\d+:\d+', line.strip()).group(0), '%b %d %H:%M:%S').replace(
            year=datetime.utcnow().year)
        user, type_connections = re.search('[\w-]+[.]\w+', line.strip()).group(0).split('.')
        delta = (target_date - date).days
        if delta == 0:
            result.append([date, user, type_connections])
    result.sort()
    return result

def requestString(deltaDays, ipAddress):
    if deltaDays == 0:
        return "cat /log_storage/radiuslogcopier/*/*.log 2>/dev/null | grep \" {IpAddress} \" | " \
               "grep 'Send ADD' | sed 's/  / 0/g' | sort -u"\
            .format(IpAddress=ipAddress)
    else:
        return "xzcat /log_storage/radiuslogcopier/*/*.log.{DeltaDays}.xz 2>/dev/null | " \
               "grep \" {IpAddress} \" | grep 'Send ADD' | sed 's/  / 0/g' | sort -u"\
            .format(DeltaDays=deltaDays - 1, IpAddress=ipAddress)

def st_update(ticketKey, **kwargs):
    st_client.issues[ticketKey].update(**kwargs)

def st_comment(ticketKey, **kwargs):
    st_client.issues[ticketKey].comments.create(**kwargs)

# Start

@exc_thread_wrapper
def start_check_abuse():
    logger.info('Start CheckAbuse')
    tickets = st_client.issues.find('Queue: "Helpdesk Requests" and Author: "abuse abuse" and Resolution: empty() Components: !Robot_Issues ')
    if tickets:
        #создаем подключение к perry
        ssh_client = paramiko.SSHClient()
        pkey = paramiko.RSAKey.from_private_key_file(PRIVATE_KEY, '1qJ@zEZt')
        ssh_client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        ssh_client.connect('perry.yandex-team.ru', username='robot-help', pkey=pkey)
        #
        for ticket in tickets:
            ticketKey = ticket.key
            ticketDescr = ticket.description

            timeStamp = get_ticket_field("TimeStamp>", "/TimeStamp>", ticketDescr)
            ipAddress = get_ticket_field("IP_Address>", "/IP_Address>", ticketDescr)
            fileName = get_ticket_field("FileName>", "/FileName>", ticketDescr)
            event_datetime = datetime.strptime(timeStamp[:19], "%Y-%m-%dT%H:%M:%S") + timedelta(hours=3)
            logger.debug('Find abuse tiket: ' + ticketKey)
            logger.debug('Tiket time: ' + timeStamp)
            logger.debug('Tiket IP: ' + ipAddress)
            logger.debug('Tiket file name: ' + fileName)
            st_update(ticketKey,
                type='serviceRequest',
                components='Robot_Issues',
                deadline=(datetime.now() + timedelta(days=7)).strftime("%Y-%m-%d")
                )
            script_out = check_logs(ipAddress, timeStamp, ssh_client)
            stMessage = "Имя файла: {FileName}\n" \
                        "Дата: {DateTime}\n" \
                        "IP адресс: {IPAddress}\n" \
                        "Тип подключения: {type}\n\n" \
                        "{logs}".format(FileName=fileName,
                                        DateTime=event_datetime,
                                        IPAddress=ipAddress,
                                        type=script_out[1],
                                        logs=script_out[0]
                                        )
            stMessageInv = 'Привет, с Вашего компьютера обнаружена торрент-активность ({filename}). Напоминаем Вам, ' \
                           'что скачивать торренты из нашей сети (включая VPN) запрещено. Убедительная просьба ' \
                           'либо удалить торрент-клиент, либо контролировать его трафик.\n' \
                           '**Сообщите в данном тикете о проделанных операциях.**'.format(filename=fileName)
            logger.debug('Result: ' + stMessage)
            st_comment(ticketKey, text=stMessage, summonees='gg0sha')
            try:
                st_comment(ticketKey, text=stMessageInv, summonees=script_out[2])
            except Exception as error:
                script_out.append(None)
                logger.error('Failed to invite a goal. ({error})'.format(error=error))
            logger.info('Finish CheckAbuse')
            return [ticketKey, stMessageInv, script_out[2]]
    else:
        logger.info('Ticket not found.')
    return 'Not found'