from source.config import *
from source.monitoring.monitoring import SimpleYTBasedCollector
from source.utils import exc_thread_wrapper, SerenityCollector

logger = logging.getLogger(__name__)


class DifferentNodeMobilesCollector(SimpleYTBasedCollector):
    def __init__(self, **kwargs):
        name = kwargs.get('name')
        node_url = kwargs.get('node_url')
        search_id = kwargs.get('search_id')
        super().__init__(yt_table_name='cmdb/jss_all/mobile_devices_{}'.format(name),
                         recreate=False,
                         client=YT_HAHN_CLIENT,
                         is_table_dynamic=False,
                         static_append=False)

        self.schema = [
            {'name': 'id', 'type': 'int64'},
            {'name': 'name', 'type': 'string'},
            {'name': 'udid', 'type': 'string'},
            {'name': 'username', 'type': 'string'},
            {'name': 'serial_number', 'type': 'string'},
            {'name': 'model', 'type': 'string'},
            {'name': 'last_enrollment', 'type': 'string'},
            {'name': 'last_inventory_update', 'type': 'string'},
            {'name': 'ios_version', 'type': 'string'},
        ]
        self.mob_collect = SerenityCollector(url='https://{}/JSSResource/'.format(node_url))
        self.search_id = search_id
        self.collector_name = name

    def _analyze_one_record(self, record):
        result = {}
        for item in record:
            lower_item = item.lower()
            if lower_item in [x["name"] for x in self.schema]:
                result[lower_item] = record[item]
        return result

    def _fetch_data(self):
        result = []
        raw_data =  self.mob_collect.query(query='advancedmobiledevicesearches/id/{}'.format(self.search_id))
        data = raw_data['advanced_mobile_device_search']['mobile_devices']
        for item in data:
            result.append(self._analyze_one_record(item))
        return result

    def main(self):
        logger.info('Start mobile sync : {}'.format(self.collector_name))
        data = self._fetch_data()
        self.write_data_to_yt(data)

@exc_thread_wrapper
def main_different_mobile_devices():
    DifferentNodeMobilesCollector(
        name='confroom',
        node_url='mdm.confroom.techadmin.yandex.net:8443',
        search_id=2
    ).main()
    DifferentNodeMobilesCollector(
        name='sdc',
        node_url='admin.sdc-mdm.techadmin.yandex.net',
        search_id=1
    ).main()
    DifferentNodeMobilesCollector(
        name='smartpass',
        node_url='admin.tranquility.yandex.net',
        search_id=3
    ).main()